#include <qapplication.h>

#include "xpms_notemenu.h"
#include "config.h"
#include "notemenu.h"

extern Config *defCfg;

NoteMenu::NoteMenu(Note *parent) : QPopupMenu (parent) {
	QPixmap micon1(xpm_notemenu_insertdate);
	QPixmap micon2(xpm_notemenu_mail);
	QPixmap micon3(xpm_notemenu_print);
	QPixmap micon4(xpm_notemenu_prefs);
	QPixmap micon5(xpm_notemenu_rename);
	QPixmap micon6(xpm_notemenu_delete);
	QPixmap micon7(xpm_notemenu_insertdate);

	heading = new QLabel(parent->getName(), this);
	heading->setAlignment(AlignCenter);
	updateFonts();
	
	insertItem (heading);
	insertItem (micon1, "Insert &date", parent, SLOT(insertDate()), CTRL+Key_D);
	insertSeparator();
	insertItem (micon3, "&Pipe to command...", parent, SLOT(pipe()), CTRL+Key_P);
	insertItem (micon7, "&Alarm", parent, SLOT(showAlarmCl()), CTRL+Key_A);
	insertItem (micon4, "C&onfigure", parent, SLOT(showPrefs()), CTRL+Key_O);
	insertSeparator();
	insertItem (micon5, "&Rename", parent, SLOT(rename()), CTRL+Key_R);
	insertItem (micon6, "Delete", parent, SLOT(Delete()));
}

void NoteMenu::updateFonts() {
	setFont(defCfg->fontMenu);
	heading->setFont(defCfg->fontHeading);	
}

void NoteMenu::updateTitle(const QString *title) {
	heading->setText(*title);
}
