#ifndef printh
#define printh

#include <qprocess.h>
#include <qtimer.h>
#include <qstring.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qevent.h>
#include <qlabel.h>

#include "note.h"
#include "config.h"

class Pipe : public QWidget{
	Q_OBJECT
	
	private:
		Note *parent;
		QProcess *process;
		QString *stdOut, *stdErr;
		bool ok;
		QPushButton *buttonOK, *buttonCancel;
		QComboBox *listBox;
		QCheckBox *checkPipe, *checkSelText;
		QLabel *heading;
		QString  *bufText, *bufSelText;
	
	public:
		Pipe(Note *p, QString bufText, QString bufSelText = QString());
		~Pipe();
	
		// Events
		void keyPressEvent(QKeyEvent *e);
	
	public slots:
		void clickOK();
		void clickCancel();
		void textChanged(const QString &t);
		void readStdOut();
		void readStdErr();
		void cmdFinished();
};

#endif
