#include <qapplication.h>
#include <qpixmap.h>
#include <qimage.h>
#include <qstring.h>
#include <qmessagebox.h>

#include "xpms_snotes.h"
#include "config.h"
#include "snotes.h"
#include "x11routines.h"

#define APPVERSION "1.1.5"

AlarmSv *alarmServer;
extern Config *defCfg;

Snotes::Snotes() : QLabel(0, 0, WStyle_NoBorder | WGroupLeader | WStyle_Customize) {
	defCfg->setpSnotes(this);
	setCaption("Snotes");
	setIcon(QPixmap(xpm_main_icon));
	X11Rt::setClassName(this, QString("Snotes"), QString("Snotes"));

	prgmenu = new Menu(this);
	notesmenu = new NoteList(this);

	setGeometry((defCfg->iconPosX == -1) ? geometry().x() : defCfg->iconPosX, (defCfg->iconPosY == -1) ? geometry().y() : defCfg->iconPosY, 10, 10);
	qApp->setMainWidget(this);
	
 	connect(qApp, SIGNAL(aboutToQuit()), this, SLOT(qappAboutToQuit()));
}

int Snotes::run() {
	updateConfig();

	show();

	X11Rt::setWmFlags(this, defCfg->iconLayer, defCfg->iconSticky, defCfg->iconSkipTaskbar);
	
	Note::openNotes();
	alarmServer = new AlarmSv;

	return qApp->exec();
}

Snotes::~Snotes() {
	delete prgmenu;
	delete notesmenu;
}

void Snotes::updateNotesList() {
	notesmenu->updateList();
}

void Snotes::updateConfig() {
	if(isVisible())
		X11Rt::setWmFlags(this, defCfg->iconLayer, defCfg->iconSticky, defCfg->iconSkipTaskbar);

	prgmenu->updateFonts();
	notesmenu->updateFonts();
	
	Note::updateAll();
}

//---------------- Events -----------------------------
void Snotes::mousePressEvent(QMouseEvent *e) {
	switch (e->button()) {
		case LeftButton:
			notesmenu->popup(e->globalPos());
			break;
		case RightButton:
			prgmenu->popup(e->globalPos());
			break;
		case MidButton:
			new_note_clipboard();
			break;
		default:
			e->ignore();
	}
}

void Snotes::resizeEvent (QResizeEvent * e) {
	QImage qappImage(xpm_main_icon);
	setPixmap(qappImage.smoothScale(e->size()));
	update();	
}

// -------------------------- SLOTS -----------------------------
void Snotes::new_note() {
	Note::New();
}

void Snotes::new_note_clipboard() {
	Note::New(true);
}

void Snotes::prefs() {
	defCfg->show();
}

void Snotes::about() {
	QMessageBox::about( this, "Sticky Notes by JVC. (v" APPVERSION ")",
		"Sticky Notes v" APPVERSION ":\n"
	    "\n"
		"Written November/December 2004 - mostly for\n"
		"my own use. There are some (minor) bugs; see\n"
		"the README file distributed with this packages\n"
		"for further information.\n"
		"\n"
		"Best regards\n"
		"Jrn Christensen\n");
}

void Snotes::aboutqt() {
	QMessageBox::aboutQt( this, "Sticky Notes" );
}

void Snotes::qappAboutToQuit() {
	Note::closeAll();
}
