#include "spinbox.h"

SpinBox::SpinBox(QWidget *p) : QSpinBox(p), useDayNames(false) {  }

QString SpinBox::mapValueToText (int v) {
	if(useDayNames)
		switch(v) {
			case 0:
				return QString("Sun");
				break;
			case -1:
				return QString("Sat");
				break;
			case -2:
				return QString("Fri");
				break;
			case -3:
				return QString("Thu");
				break;
			case -4:
				return QString("Wed");
				break;
			case -5:
				return QString("Tue");
				break;
			case -6:
				return QString("Mon");
				break;
		default:
			// Do nothing
			break;
	}
	
	if(v < 10)
		return QString("0") + QString().setNum(v);
	else
		return QString().setNum(v);		
}
