#include <qapplication.h>
#include <qfontdialog.h>
#include <qcolordialog.h>
#include <qfont.h>
#include <qstringlist.h>
#include <qfiledialog.h>

#include "tabWidgets.h"
#include "dialogfonts.h"

extern Config *defCfg;

// ------------------------------- tabIcon ----------------------------
tabIcon::tabIcon(QWidget *p) : QWidget(p) {
	// Main layout
	layout = new QGridLayout(this, 2, 2, 5);
	
	//wigetIconStartup
	widgetIconStartup = new QWidget(this);
	layoutIconStartup = new QGridLayout(widgetIconStartup, 4, 4, 5);
	spinX = new QSpinBox(-1, QApplication::desktop()->width(), 1, widgetIconStartup);
	spinY = new QSpinBox(-1, QApplication::desktop()->height(), 1, widgetIconStartup);
	checkSavePosOnClose = new QCheckBox(QString("Save position on close."), widgetIconStartup);
	l1 = new QLabel(QString("Icon start up position:"), widgetIconStartup);
	l2 = new QLabel(QString("Set:"), widgetIconStartup);
	l3 = new QLabel(QString("X"), widgetIconStartup);
	l4 = new QLabel(QString("Set to -1 for don't care."), widgetIconStartup);
	spinX->setFont(font_normtext);
	spinY->setFont(font_normtext);
	checkSavePosOnClose->setFont(font_normtext);
	l1->setFont(font_heading);
	l2->setFont(font_normtext);
	l3->setFont(font_normtext);
	l4->setFont(font_normtext);
	layoutIconStartup->addMultiCellWidget(l1, 0, 0, 0, 3, AlignCenter);
	layoutIconStartup->addWidget(l2, 1, 0, AlignRight);
	layoutIconStartup->addWidget(spinX, 1, 1);
	layoutIconStartup->addWidget(l3, 1, 2, AlignCenter);
	layoutIconStartup->addWidget(spinY, 1, 3);
	layoutIconStartup->addMultiCellWidget(l4, 2, 2, 0, 3, AlignCenter);
	layoutIconStartup->addMultiCellWidget(checkSavePosOnClose, 3, 3, 0, 3, AlignLeft);
	
	// widgetMenuFonts
	widgetMenuFonts = new QWidget(this);
	layoutMenuFonts = new QGridLayout(widgetMenuFonts, 3, 2, 5);
	labelFontHeading = new QLabel(QString(), widgetMenuFonts);
	labelFontText = new QLabel(QString(), widgetMenuFonts);
	buttonFontHeading = new QPushButton("Select title...", widgetMenuFonts);
	buttonFontText = new QPushButton("Select text...", widgetMenuFonts);
	l5 = new QLabel(QString("Menu fonts:"), widgetMenuFonts);
	labelFontText->setFrameShape(QFrame::StyledPanel);
	labelFontHeading->setFrameShape(QFrame::StyledPanel);
	labelFontText->setMargin(3);
	labelFontHeading->setMargin(3);
	labelFontText->setMinimumWidth(110);
	labelFontHeading->setMinimumWidth(110);
	labelFontText->setFrameShadow(QFrame::Sunken);
	labelFontHeading->setFrameShadow(QFrame::Sunken);	
	l5->setFont(font_heading);
	buttonFontHeading->setFont(font_normtext);
	buttonFontText->setFont(font_normtext);
	layoutMenuFonts->addMultiCellWidget(l5, 0, 0, 0, 1, AlignCenter);
	layoutMenuFonts->addWidget(buttonFontHeading, 1, 0, AlignLeft);
	layoutMenuFonts->addWidget(labelFontHeading, 1, 1, AlignLeft);
	layoutMenuFonts->addWidget(buttonFontText, 2, 0, AlignLeft);
	layoutMenuFonts->addWidget(labelFontText, 2, 1, AlignLeft);

	// widgetWmHints
	widgetWmHints = new QWidget(this);
	layoutWmHints = new QGridLayout(widgetWmHints, 3, 2, 5);
	optionSkipTaskbar = new QCheckBox("Skip taskbar", widgetWmHints);
	optionSticky = new QCheckBox("Sticky", widgetWmHints);
	groupLayer = new QButtonGroup(3, Vertical, "Layer:", widgetWmHints);
	optionLayerAbove = new QRadioButton ("Above", groupLayer);
	optionLayerNormal = new QRadioButton("Normal", groupLayer);
	optionLayerBelow = new QRadioButton ("Below", groupLayer);
	groupLayer->setFont(font_groupHeading);
	optionLayerAbove->setFont(font_normtext);
	optionLayerNormal->setFont(font_normtext);
	optionLayerBelow->setFont(font_normtext);
	optionSkipTaskbar->setFont(font_normtext);
	optionSticky->setFont(font_normtext);
	l6 = new QLabel(QString("Window manager hints:"), widgetWmHints);
	l6->setFont(font_heading);
	layoutWmHints->addMultiCellWidget(l6, 0, 0, 0, 1, AlignCenter);
	layoutWmHints->addMultiCellWidget(groupLayer, 1, 2, 0, 0);
	layoutWmHints->addWidget(optionSkipTaskbar, 1, 1);
	layoutWmHints->addWidget(optionSticky, 2, 1);

	// widgetAlarmCmd
	widgetAlarmCmd = new QWidget(this);
	layoutAlarmCmd = new QGridLayout(widgetAlarmCmd, 6, 3, 5);
	l7 = new QLabel("Alarm:", widgetAlarmCmd);
	l7->setFont(font_heading);
	checkAlarmPopup = new QCheckBox("Pop up and flash note.", widgetAlarmCmd);
	checkAlarmPopup->setFont(font_normtext);
	l8 = new QLabel("Command or script:", widgetAlarmCmd);
	l8->setFont(font_normtext);
	l9 = new QLabel("%n => Note name.\n%f => Note file name.\n%% => %", widgetAlarmCmd);
	l9->setFont(font_normtext);
	editAlarmCmd = new QLineEdit(widgetAlarmCmd);
	editAlarmCmd->setFont(font_normtext);
	buttonAlarmCmd = new QPushButton("Browse...", widgetAlarmCmd);
	buttonAlarmCmd->setFont(font_normtext);
	layoutAlarmCmd->addMultiCellWidget(l7, 0, 0, 0, 1, AlignCenter);
	layoutAlarmCmd->addMultiCellWidget(checkAlarmPopup, 1, 1, 0, 1, AlignLeft);
	layoutAlarmCmd->addMultiCellWidget(l8, 2, 2, 0, 1, AlignLeft);
	layoutAlarmCmd->addWidget(editAlarmCmd, 3, 0);
	layoutAlarmCmd->addWidget(buttonAlarmCmd, 3, 1);
	layoutAlarmCmd->addMultiCellWidget(l9, 4, 4, 0, 1, AlignLeft);
	layoutAlarmCmd->setRowStretch(5, 1);

	// Set up main layout
	layout->addWidget(widgetIconStartup, 0, 0, AlignLeft);
	layout->addWidget(widgetMenuFonts, 0, 1, AlignLeft);
	layout->addWidget(widgetWmHints, 1, 0, AlignLeft);
	layout->addWidget(widgetAlarmCmd, 1, 1, AlignLeft);
	
	// Connect signals
	connect(checkSavePosOnClose, SIGNAL(toggled(bool)), SLOT(toggleSaveOnClose(bool)));
	connect(buttonFontHeading, SIGNAL(clicked()), SLOT(clickFontHead()));
	connect(buttonFontText, SIGNAL(clicked()), SLOT(clickFontText()));
	connect(buttonAlarmCmd, SIGNAL(clicked()), SLOT(clickAlarmCmd()));

	// Load initial data
	loadData();	
}

tabIcon::~tabIcon() {
	delete layout;
	delete widgetMenuFonts;
	delete widgetIconStartup;
	delete widgetWmHints;
	delete widgetAlarmCmd;
}

void tabIcon::hide() {
	QWidget::hide();
	widgetMenuFonts->hide();
	widgetIconStartup->hide();
	widgetWmHints->hide();
	widgetAlarmCmd->hide();
}

void tabIcon::show() {
	widgetMenuFonts->show();
	widgetIconStartup->show();
	widgetWmHints->show();
	widgetAlarmCmd->show();
	QWidget::show();
}

void tabIcon::loadData(Config *c) {
	if (!c)
		c = defCfg;

	spinX->setValue(c->iconPosX);
	spinY->setValue(c->iconPosY);
	checkSavePosOnClose->setChecked(c->iconSavePos);
	spinX->setEnabled(!c->iconSavePos);
	spinY->setEnabled(!c->iconSavePos);
	if(c->iconLayer == 1)
		optionLayerAbove->setChecked(true);
	else if(c->iconLayer == 2)
		optionLayerBelow->setChecked(true);
	else
		optionLayerNormal->setChecked(true);
	optionSkipTaskbar->setChecked(c->iconSkipTaskbar);
	optionSticky->setChecked(c->iconSticky);
	labelFontHeading->setText(c->fontHeading.family() + 
		QString(", ") + 
		QString::number(c->fontHeading.pointSize()));
	labelFontHeading->setFont(c->fontHeading);
	labelFontText->setText(c->fontMenu.family() + 
		QString(", ") + 
		QString::number(c->fontMenu.pointSize()));
	labelFontText->setFont(c->fontMenu);
	
	editAlarmCmd->setText(c->alarmCmd);
	checkAlarmPopup->setChecked(c->popupNote);
}

void tabIcon::saveData() {
	if(!(defCfg->iconSavePos = checkSavePosOnClose->isChecked())) {
		defCfg->iconPosX = spinX->value();
		defCfg->iconPosY = spinY->value();
	}
	
	if(optionLayerAbove->isChecked())
		defCfg->iconLayer = 1;
	else if(optionLayerBelow->isChecked())
		defCfg->iconLayer = 2;
	else
		defCfg->iconLayer = 0;
	
	defCfg->iconSkipTaskbar = optionSkipTaskbar->isChecked();
	defCfg->iconSticky = optionSticky->isChecked();
	defCfg->fontHeading = labelFontHeading->font();
	defCfg->fontMenu= labelFontText->font();
	defCfg->alarmCmd = editAlarmCmd->text();
	defCfg->popupNote = checkAlarmPopup->isChecked();
}

void tabIcon::toggleSaveOnClose(bool v) {
	spinX->setEnabled(!v);
	spinY->setEnabled(!v);
}
	
void tabIcon::clickFontHead() {
	bool ok;
	QFont f(QFontDialog::getFont(&ok, labelFontHeading->font(), this));
	if(ok) {
		labelFontHeading->setText(f.family() + QString(", ") + 
			QString::number(f.pointSize()));
		labelFontHeading->setFont(f);
	}
}

void tabIcon::clickFontText() {
	bool ok;
	QFont f(QFontDialog::getFont(&ok, labelFontHeading->font(), this));
	if(ok) {
		labelFontText->setText(f.family() + QString(", ") + 
			QString::number(f.pointSize()));
		labelFontText->setFont(f);
	}	
}

void tabIcon::clickAlarmCmd() {
	QString tmp;
	if(tmp = QFileDialog::getOpenFileName(editAlarmCmd->text(), "All files (*)", this, 0, "Please select a file..."))
		editAlarmCmd->setText(tmp);	
}

// ------------------------------- tabNotes ----------------------------
tabNotes::tabNotes(QWidget *p) : QWidget(p) {
	// Main layout
	layout = new QGridLayout(this, 2, 4, 5);
	
	
	// widgetNewNoteSize
	widgetNewNoteSize = new QWidget(this);
	layoutNewNoteSize = new QGridLayout(widgetNewNoteSize, 4, 4, 5);
	l1 = new QLabel("Initial size for new notes:", widgetNewNoteSize);
	sliderWidth = new QSlider(100, 600, 1, defCfg->noteWidth, Horizontal, widgetNewNoteSize);
	sliderHeight = new QSlider(100, 600, 1, defCfg->noteHeight, Vertical, widgetNewNoteSize);
	sliderWidth->setTickmarks(QSlider::Below);
	sliderHeight->setTickmarks(QSlider::Right);
	sliderWidth->setTickInterval(100);
	sliderHeight->setTickInterval(75);
	sliderWidth->setFixedWidth(75);
	sliderHeight->setFixedHeight(75);
	labelSize = new QLabel(widgetNewNoteSize);
	sliderWidth->setFont(font_normtext);
	sliderHeight->setFont(font_normtext);
	labelSize->setFont(font_normtext);
	l1->setFont(font_heading);
	layoutNewNoteSize->addMultiCellWidget(l1, 0, 0, 0, 3, AlignCenter);
	layoutNewNoteSize->addMultiCellWidget(sliderWidth, 1, 1, 1, 3, AlignLeft);
	layoutNewNoteSize->addMultiCellWidget(sliderHeight, 2, 4, 0, 0);
	layoutNewNoteSize->addMultiCellWidget(labelSize, 3, 3, 1, 2, AlignCenter);
	
	// widgetFonts
	widgetFonts = new QWidget(this);
	layoutFonts = new QGridLayout(widgetFonts, 3, 2, 5);
	buttonFontTitle = new QPushButton("Select title...", widgetFonts);
	buttonFontText = new QPushButton("Select text...", widgetFonts);
	labelFontTitle = new QLabel(widgetFonts, 0, WStyle_NormalBorder);
	labelFontText = new QLabel(widgetFonts, 0, WStyle_NormalBorder);
	l2 = new QLabel("Default fonts:", widgetFonts);
	buttonFontTitle->setFont(font_normtext);
	buttonFontText->setFont(font_normtext);
	l2->setFont(font_heading);
	layoutFonts->addMultiCellWidget(l2, 0, 0, 0, 1, AlignCenter);
	layoutFonts->addWidget(buttonFontTitle, 1, 0, AlignLeft);
	layoutFonts->addWidget(labelFontTitle, 1, 1, AlignLeft);
	layoutFonts->addWidget(buttonFontText, 2, 0, AlignLeft);
	layoutFonts->addWidget(labelFontText, 2, 1, AlignLeft);
	labelFontText->setFrameShape(QFrame::StyledPanel);
	labelFontTitle->setFrameShape(QFrame::StyledPanel);
	labelFontText->setMargin(3);
	labelFontTitle->setMargin(3);
	labelFontText->setMinimumWidth(110);
	labelFontTitle->setMinimumWidth(110);
	labelFontText->setFrameShadow(QFrame::Sunken);
	labelFontTitle->setFrameShadow(QFrame::Sunken);
	
	// widgetColors
	widgetColors = new QWidget(this);
	layoutColors = new QGridLayout(widgetColors, 4, 6, 5);
	buttonColorTitleBg = new QPushButton(widgetColors);
	buttonColorTitleFg = new QPushButton(widgetColors);
	buttonColorBodyFg = new QPushButton(widgetColors);
	buttonColorBodyBg = new QPushButton(widgetColors);
	l4 = new QLabel("Default colors:", widgetColors);
	l5 = new QLabel("Title bar", widgetColors);
	l6 = new QLabel("Text area", widgetColors);
	l7 = new QLabel("Foreground", widgetColors);
	l8 = new QLabel("Background", widgetColors);
	l4->setFont(font_heading);
	l5->setFont(font_heading);
	l6->setFont(font_heading);
	l7->setFont(font_heading);
	l8->setFont(font_heading);
	layoutColors->addMultiCellWidget(l4, 0, 0, 0, 5, AlignCenter);
	layoutColors->addMultiCellWidget(l5, 1, 1, 2, 3, AlignCenter);
	layoutColors->addMultiCellWidget(l6, 1, 1, 4, 5, AlignCenter);
	layoutColors->addMultiCellWidget(l7, 2, 2, 0, 1, AlignLeft);
	layoutColors->addMultiCellWidget(buttonColorTitleFg, 2, 2, 2, 3, AlignLeft);
	layoutColors->addMultiCellWidget(l8, 3, 3, 0, 1, AlignLeft);
	layoutColors->addMultiCellWidget(buttonColorTitleBg, 3, 3, 2, 3, AlignLeft);
	layoutColors->addMultiCellWidget(buttonColorBodyFg, 2, 2, 4, 5, AlignLeft);
	layoutColors->addMultiCellWidget(buttonColorBodyBg, 3, 3, 4, 5, AlignLeft);
	
	// widgetOptions
	widgetOptions = new QWidget(this);
	layoutOptions = new QGridLayout(widgetOptions, 3, 2, 5);
	checkAutoIndent = new QCheckBox("Auto indent", widgetOptions);
	spinTabSize = new QSpinBox(1, 256, 1, widgetOptions);
	spinTabSize->setMaximumWidth(50);
	l3 = new QLabel("Default options:", widgetOptions);
	l11 = new QLabel("Tab size:", widgetOptions);
	checkAutoIndent->setFont(font_normtext);
	spinTabSize->setFont(font_normtext);
	l3->setFont(font_heading);
	l11->setFont(font_normtext);
	layoutOptions->addMultiCellWidget(l3, 0, 0, 0, 1, AlignCenter);
	layoutOptions->addWidget(l11, 1, 0, AlignLeft);
	layoutOptions->addWidget(spinTabSize, 1, 1, AlignLeft);
	layoutOptions->addMultiCellWidget(checkAutoIndent, 2, 2, 0, 1, AlignLeft);
	
	// WidgetWmHints
	widgetWmHints = new QWidget(this);
	layoutWmHints = new QGridLayout(widgetWmHints, 3, 2, 5);
	optionSkipTaskbar = new QCheckBox("Skip taskbar", widgetWmHints);
	optionSticky = new QCheckBox("Sticky", widgetWmHints);
	groupLayer = new QButtonGroup(3, Vertical, "Layer:", widgetWmHints);
	optionLayerAbove = new QRadioButton ("Above", groupLayer);
	optionLayerNormal = new QRadioButton("Normal", groupLayer);
	optionLayerBelow = new QRadioButton ("Below", groupLayer);
	groupLayer->setFont(font_groupHeading);
	optionLayerAbove->setFont(font_normtext);
	optionLayerNormal->setFont(font_normtext);
	optionLayerBelow->setFont(font_normtext);
	optionSkipTaskbar->setFont(font_normtext);
	optionSticky->setFont(font_normtext);
	l6 = new QLabel(QString("Window manager hints:"), widgetWmHints);
	l6->setFont(font_heading);
	layoutWmHints->addMultiCellWidget(l6, 0, 0, 0, 1, AlignCenter);
	layoutWmHints->addMultiCellWidget(groupLayer, 1, 2, 0, 0);
	layoutWmHints->addWidget(optionSkipTaskbar, 1, 1);
	layoutWmHints->addWidget(optionSticky, 2, 1);
	

	// Set mainup layout
	layout->addWidget(widgetNewNoteSize, 0, 0, AlignHCenter | AlignTop);
	layout->addMultiCellWidget(widgetOptions, 0, 0, 1, 2, AlignHCenter | AlignTop);
	layout->addWidget(widgetWmHints, 0, 3, AlignHCenter | AlignTop);
	layout->addMultiCellWidget(widgetFonts, 1, 1, 0, 1, AlignHCenter | AlignTop);
	layout->addMultiCellWidget(widgetColors, 1, 1, 2, 3, AlignHCenter | AlignTop);
	
	// Connect signals
	connect(sliderWidth, SIGNAL(valueChanged(int)), SLOT(sliderWidthChanged(int)));
	connect(sliderHeight, SIGNAL(valueChanged(int)), SLOT(sliderHeightChanged(int)));
	connect(buttonFontText, SIGNAL(clicked()), SLOT(showFontText()));
	connect(buttonFontTitle, SIGNAL(clicked()), SLOT(showFontTitle()));
	connect(buttonColorTitleFg, SIGNAL(clicked()), SLOT(showColorTitleFg()));
	connect(buttonColorTitleBg, SIGNAL(clicked()), SLOT(showColorTitleBg()));
	connect(buttonColorBodyFg, SIGNAL(clicked()), SLOT(showColorBodyFg()));
	connect(buttonColorBodyBg, SIGNAL(clicked()), SLOT(showColorBodyBg()));

	// Load initial data
	loadData();	
}

tabNotes::~tabNotes() {
	delete layout;
	delete widgetNewNoteSize;
	delete widgetFonts;
	delete widgetColors;
	delete widgetOptions;
	delete widgetWmHints;
}

void tabNotes::hide() {	
	QWidget::hide();
	widgetNewNoteSize->hide();
	widgetFonts->hide();
	widgetColors->hide();
	widgetOptions->hide();
	widgetWmHints->hide();
}

void tabNotes::show() {
	widgetNewNoteSize->show();
	widgetFonts->show();
	widgetColors->show();
	widgetOptions->show();
	widgetWmHints->show();
	QWidget::show();
}

void tabNotes::loadData(Config *c) {
	if (!c)
		c = defCfg;
	
	sliderWidth->setValue(c->noteWidth);
	sliderHeight->setValue(c->noteHeight);
	
	labelSize->setText(QString::number(sliderWidth->value()) 
		+ QString(" X ") + QString::number(sliderHeight->value()));
	
	labelFontTitle->setFont(c->fontTitle);
	labelFontTitle->setText(c->fontTitle.family() + 
		QString(", ") +
		QString::number(c->fontTitle.pointSize()));
	labelFontText->setFont(c->fontBody);
	labelFontText->setText(c->fontBody.family() + 
		QString(", ") +
		QString::number(c->fontBody.pointSize()));

	buttonColorTitleFg->setPaletteBackgroundColor(c->colorTitleFg);
	buttonColorTitleBg->setPaletteBackgroundColor(c->colorTitleBg);
	buttonColorBodyFg->setPaletteBackgroundColor(c->colorBodyFg);
	buttonColorBodyBg->setPaletteBackgroundColor(c->colorBodyBg);

	spinTabSize->setValue(c->noteTabSize);
	checkAutoIndent->setChecked(c->noteAutoIndent);
	if(c->noteLayer == 1)
		optionLayerAbove->setChecked(true);
	else if(c->noteLayer == 2)
		optionLayerBelow->setChecked(true);
	else
		optionLayerNormal->setChecked(true);
	optionSkipTaskbar->setChecked(c->noteSkipTaskbar);
	optionSticky->setChecked(c->noteSticky);
}

void tabNotes::saveData() {
	defCfg->noteWidth = sliderWidth->value();
	defCfg->noteHeight = sliderHeight->value();
	
	defCfg->fontTitle = labelFontTitle->font();
	defCfg->fontBody = labelFontText->font();

	defCfg->colorTitleFg = buttonColorTitleFg->paletteBackgroundColor();
	defCfg->colorTitleBg = buttonColorTitleBg->paletteBackgroundColor();
	defCfg->colorBodyFg = buttonColorBodyFg->paletteBackgroundColor();
	defCfg->colorBodyBg = buttonColorBodyBg->paletteBackgroundColor();

	defCfg->noteTabSize = spinTabSize->value();
	defCfg->noteAutoIndent = checkAutoIndent->isChecked();
	if(optionLayerAbove->isChecked())
		defCfg->noteLayer = 1;
	else if(optionLayerBelow->isChecked())
		defCfg->noteLayer = 2;
	else
		defCfg->noteLayer = 0;
	defCfg->noteSticky = optionSticky->isChecked();
	defCfg->noteSkipTaskbar = optionSkipTaskbar->isChecked();
}

void tabNotes::sliderHeightChanged(int n) {
	labelSize->setText(QString::number(sliderWidth->value()) 
		+ QString(" X ") + QString::number(n));
}

void tabNotes::sliderWidthChanged(int n) {
	labelSize->setText(QString::number(n) + QString(" X ") + 
		QString::number(sliderHeight->value()));
}

void tabNotes::showFontTitle() {
	bool OK;  // Nescesary for QFontDialog - but not used.
	labelFontTitle->setFont(QFontDialog::getFont(&OK,
		labelFontTitle->font(), this));
	labelFontTitle->setText(labelFontTitle->font().family() + 
		QString(", ") +
		QString::number(labelFontTitle->font().pointSize()));
}

void tabNotes::showFontText() {
	bool OK;  // Nescesary for QFontDialog - but not used.
	labelFontText->setFont(QFontDialog::getFont(&OK,
		labelFontText->font(), this));
	labelFontText->setText(labelFontText->font().family() + 
		QString(", ") +
		QString::number(labelFontText->font().pointSize()));
}

void tabNotes::showColorTitleFg() {
	QColor nColor(QColorDialog::getColor(buttonColorTitleFg->paletteBackgroundColor(), this));
	if (nColor.isValid())
		buttonColorTitleFg->setPaletteBackgroundColor(nColor);	
}

void tabNotes::showColorTitleBg() {
	QColor nColor(QColorDialog::getColor(buttonColorTitleBg->paletteBackgroundColor(), this));
	if (nColor.isValid())
		buttonColorTitleBg->setPaletteBackgroundColor(nColor);	
}

void tabNotes::showColorBodyFg() {
	QColor nColor(QColorDialog::getColor(buttonColorBodyFg->paletteBackgroundColor(), this));
	if (nColor.isValid())
		buttonColorBodyFg->setPaletteBackgroundColor(nColor);
}

void tabNotes::showColorBodyBg() {
	QColor nColor(QColorDialog::getColor(buttonColorBodyBg->paletteBackgroundColor(), this));
	if (nColor.isValid())
		buttonColorBodyBg->setPaletteBackgroundColor(nColor);	
}

// ------------------------------- tabCommands ---------------------------
tabCommands::tabCommands(QWidget *p) : QWidget(p), actionAdd(true) {
	// Main layout
	layout = new QGridLayout(this, 1, 1, 5);
	
	// Here we only got one widget
	widgetCommands = new QWidget(this);
	layoutCommands = new QGridLayout(widgetCommands, 6, 4, 5);
	listCommands = new QListBox(widgetCommands);
	editCommand = new LineEdit(widgetCommands);
	checkPipe = new QCheckBox("Send stdout to new note.", widgetCommands);
	buttonAddRemove = new QPushButton(widgetCommands);
	l1 = new QLabel("Default pipe commands", widgetCommands);
	l2 = new QLabel("Here you can set up a list of programs in the \"Pipe command...\" menu.\n"
					"The command line can be edited before execution.\n"
					"The program must accept input from stdin.\n"
					"Stdout can be directed to a new note.", widgetCommands);
	listCommands->setFont(font_normtext);
	editCommand->setFont(font_normtext);
	checkPipe->setFont(font_normtext);
	buttonAddRemove->setFont(font_normtext);
	l1->setFont(font_heading);
	l2->setFont(font_normtext);
	listCommands->resize(listCommands->sizeHint());
	layoutCommands->addMultiCellWidget(l1, 0, 0, 1, 2, AlignCenter);
	layoutCommands->addMultiCellWidget(l2, 1, 1, 1, 2, AlignCenter);
	layoutCommands->addWidget(editCommand, 3, 1, AlignLeft);
	layoutCommands->addWidget(checkPipe, 4, 1, AlignLeft);
	layoutCommands->addWidget(buttonAddRemove, 5, 1, AlignCenter);
	layoutCommands->addMultiCellWidget(listCommands, 3, 5, 2, 2);
	layoutCommands->setColStretch(0, 1);
	layoutCommands->setColStretch(3, 1);
	layoutCommands->setRowSpacing(2, 5);
	
	// set up main layout
	layout->addWidget(widgetCommands, 0, 0);
	
	// Connect signals
	connect(editCommand, SIGNAL(gotFocus()), SLOT(editCommandGotFocus()));
	connect(listCommands, SIGNAL(highlighted (const QString & )), SLOT(listCommandsChanged(const QString &)));
	connect(buttonAddRemove, SIGNAL(clicked()), SLOT(buttonClicked()));
	connect(checkPipe, SIGNAL(clicked()), SLOT(editCommandGotFocus()));
	connect(editCommand, SIGNAL(returnPressed()), buttonAddRemove,  SLOT(animateClick()));
	
	// Load initial data
	loadData();	
}

tabCommands::~tabCommands() {
	delete layout;
	delete widgetCommands;
}

void tabCommands::hide() {
	QWidget::hide();
	widgetCommands->hide();
}

void tabCommands::show() {
	widgetCommands->show();
	QWidget::show();
}


void tabCommands::loadData(Config *c) {
	if (!c)
		c = defCfg;
	
	listCommands->clear();
	QStringList all(c->cmdRun);
	for (QStringList::iterator it = c->cmdPipe.begin(); it != c->cmdPipe.end(); it++)
		all << (*it + QString(" [Pipe]"));
	all.sort();
	listCommands->insertStringList(all);
	
	editCommand->clear();
	checkPipe->setChecked(false);
	
	buttonAddRemove->setText("Add =>");
}

void tabCommands::saveData() {
	QString t;
	
	defCfg->cmdRun.clear();
	defCfg->cmdPipe.clear();
	
	for(unsigned int i = 0; i < listCommands->count(); i++)
		if ((t = listCommands->text(i)).right(7) == " [Pipe]")
			defCfg->cmdPipe << t.left(t.length() - 7);
		else
			defCfg->cmdRun << t;
}

void tabCommands::editCommandGotFocus() {
	actionAdd = true;
	listCommands->clearSelection();
	buttonAddRemove->setText("Add =>");
}

void tabCommands::buttonClicked() {
	if(actionAdd) {
		if(!editCommand->text().isEmpty()) {
			if (checkPipe->isChecked())
				listCommands->insertItem(editCommand->text() + QString(" [Pipe]"));
			else
				listCommands->insertItem(editCommand->text());
			
			listCommands->sort();
		}
	}
	else
		listCommands->removeItem(listCommands->currentItem());
}

void tabCommands::listCommandsChanged(const QString &t) {
	actionAdd = false;
	buttonAddRemove->setText("Remove <=");
	
	if (t.right(7) == " [Pipe]") {
		editCommand->setText(t.left(t.length() - 7));
		checkPipe->setChecked(true);
	}
	else {
		editCommand->setText(t);
		checkPipe->setChecked(false);
	}
}
