#ifndef tabwidgetsh
#define tabwidgetsh

#include <qwidget.h>
#include <qspinbox.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qslider.h>
#include <qlistbox.h>

#include "config.h"
#include "lineedit.h"

class Config;

// ------------------------------- tabIcon ---------------------------

class tabIcon : public QWidget {
	Q_OBJECT
	
	private:
		QGridLayout *layout, *layoutWmHints, *layoutIconStartup, *layoutMenuFonts, *layoutAlarmCmd;
		QSpinBox *spinX, *spinY;
		QCheckBox *checkSavePosOnClose;
		QLabel *labelFontHeading, *labelFontText;
		QLabel *l1, *l2, *l3, *l4, *l5, *l6, *l7, *l8, *l9;
		QPushButton *buttonFontHeading, *buttonFontText;
		QCheckBox *optionSkipTaskbar, *optionSticky;
		QButtonGroup *groupLayer;
		QRadioButton *optionLayerBelow, *optionLayerNormal, *optionLayerAbove;
		QPushButton *buttonAlarmCmd;
		QLineEdit *editAlarmCmd;
		QCheckBox *checkAlarmPopup;
		QWidget *widgetIconStartup, *widgetMenuFonts, *widgetWmHints, *widgetAlarmCmd;
	
	public:	
		tabIcon(QWidget *p);
		~tabIcon();
		void loadData(Config *c = NULL);
		void saveData();
	
	public slots:
		void hide();
		void show();
		void toggleSaveOnClose(bool v);
		void clickFontHead();
		void clickFontText();
		void clickAlarmCmd();
};


// ------------------------------- tabNotes---------------------------

class tabNotes: public QWidget {
	Q_OBJECT

	private:
		QGridLayout *layout;
		QLabel *l1, *l2, *l3, *l4, *l5, *l6, *l7, *l8, *l11;
		QSlider *sliderWidth, *sliderHeight;
		QLabel *labelSize;
		QPushButton *buttonFontTitle, *buttonFontText;
		QLabel *labelFontTitle, *labelFontText;
		QCheckBox *checkAutoIndent, *checkStayOnTop;
		QSpinBox *spinTabSize;
		QPushButton *buttonColorTitleBg, *buttonColorTitleFg, *buttonColorBodyFg, *buttonColorBodyBg;
		QWidget *widgetNewNoteSize, *widgetFonts, *widgetColors, *widgetOptions, *widgetWmHints;
		QGridLayout *layoutNewNoteSize, *layoutFonts, *layoutColors, *layoutOptions, *layoutWmHints;
		QCheckBox *optionSkipTaskbar, *optionSticky;
		QButtonGroup *groupLayer;
		QRadioButton *optionLayerBelow, *optionLayerNormal, *optionLayerAbove;	


	public:
		tabNotes(QWidget *p);
		~tabNotes();
		void loadData(Config *c = NULL);
		void saveData();

	public slots:
		void hide();
		void show();
		void sliderHeightChanged(int n);
		void sliderWidthChanged(int n);
		void showFontText();
		void showFontTitle();
		void showColorTitleFg();
		void showColorTitleBg();
		void showColorBodyBg();
		void showColorBodyFg();
};


// ------------------------------- tabCommands ---------------------------

class tabCommands : public QWidget {
	Q_OBJECT
	
	private:
		bool actionAdd;
	
		QGridLayout *layout, *layoutCommands;
		QListBox *listCommands;
		LineEdit *editCommand;
		QCheckBox *checkPipe;
		QPushButton *buttonAddRemove;
		QLabel *l1, *l2;
		QWidget *widgetCommands;
		
	
	public:
		tabCommands(QWidget *p);
		~tabCommands();
		void loadData(Config *c = NULL);
		void saveData();

	public slots:
		void hide();
		void show();
		void editCommandGotFocus();
		void listCommandsChanged(const QString &t);
		void buttonClicked();
};

#endif
