#include <qdesktopwidget.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qapplication.h>

#include "textedit.h"


TextEdit::TextEdit(Note *p) : QTextEdit(p), parent(p), autoIndent(true) {
	QObject::connect(this, SIGNAL(returnPressed()), SLOT(handleEnter()));
	
	setLineWidth(0);
	setMargin (0);
	setTextFormat(PlainText);
}

void TextEdit::focusInEvent (QFocusEvent *) {
	parent->updateColors();
}

void TextEdit::focusOutEvent (QFocusEvent *) {
	parent->updateColors();
}

void TextEdit::updateBackground() {

}

void TextEdit::handleEnter() {
	if(!(parent->getAutoIndent()))
		return;

	int i, j;

	getCursorPosition (&i, &j);

	if(i > 0) {		
		QChar tab(9); // Tabular character
		QString line(text(i - 1));
		i = line.length();
		j = 0;
		while(j < i && line.at(j) == tab) {
			insert(tab);
			j++;
		}
	}
}

void TextEdit::keyPressEvent(QKeyEvent *e) {
	if(e->key() == Key_Escape) {
		parent->close();
		e->accept();
	}
	else
		QTextEdit::keyPressEvent(e);
}
