#include <qapplication.h>
#include <qtextedit.h>
#include <qpixmap.h>
#include <qimage.h>

#include "x11routines.h"
#include <stdio.h>

using namespace std;
#include <sys/timeb.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#define ATOMNAMES 	"_NET_WM_STATE",\
					"_NET_WM_STATE_STICKY",\
					"_NET_WM_STATE_SKIP_TASKBAR",\
					"_NET_WM_STATE_ABOVE",\
					"_NET_WM_STATE_BELOW"

#define ATOM_STATE 0
#define ATOM_STATE_STICKY 1
#define ATOM_STATE_SKIP_TASKBAR 2
#define ATOM_STATE_ABOVE 3
#define ATOM_STATE_BELOW 4

#define NUMOFNAMES 5

#define _NET_WM_STATE_REMOVE 0
#define _NET_WM_STATE_ADD 1
#define _NET_WM_STATE_TOGGLE 2

void X11Rt::setWmFlags(QWidget *window, int layer, bool sticky, bool skipTaskbar) {
	char *NAMES[] = {ATOMNAMES};
	
	Atom ATOMS[NUMOFNAMES];
	XInternAtoms(window->x11AppDisplay(), NAMES, NUMOFNAMES, false, ATOMS); // Get internal atom numbers
			
	Atom atom2Add[] = {0, 0, 0, 0};
	Atom atom2Remove[] = {0, 0, 0, 0};
	int num2Add = 0, num2Remove = 0;
	
	
	if(layer == 1) {             // Above
		atom2Add[num2Add++] = ATOMS[ATOM_STATE_ABOVE];
		atom2Remove[num2Remove++] = ATOMS[ATOM_STATE_BELOW];
	}
	else if(layer == 2) {		// Below
		atom2Remove[num2Remove++] = ATOMS[ATOM_STATE_ABOVE];
		atom2Add[num2Add++] = ATOMS[ATOM_STATE_BELOW];
	}
	else {						// Normal
		atom2Remove[num2Remove++] = ATOMS[ATOM_STATE_ABOVE];
		atom2Remove[num2Remove++] = ATOMS[ATOM_STATE_BELOW];
	}
	
	if(sticky)
		atom2Add[num2Add++] = ATOMS[ATOM_STATE_STICKY];
	else
		atom2Remove[num2Remove++] = ATOMS[ATOM_STATE_STICKY];

	if(skipTaskbar)
		atom2Add[num2Add++] = ATOMS[ATOM_STATE_SKIP_TASKBAR];
	else
		atom2Remove[num2Remove++] = ATOMS[ATOM_STATE_SKIP_TASKBAR];
	
	

	XClientMessageEvent xev;
	xev.type = ClientMessage;
	xev.window = window->winId();
	xev.message_type = ATOMS[ATOM_STATE];
	xev.format = 32;

	// Remove first:
	xev.data.l[0] = _NET_WM_STATE_REMOVE;
	xev.data.l[1] = atom2Remove[0];
	xev.data.l[2] = atom2Remove[1];
	XSendEvent(window->x11AppDisplay(), DefaultRootWindow(window->x11AppDisplay()), false, SubstructureNotifyMask, (XEvent *) &xev );
	if(num2Remove > 2) {
		xev.data.l[1] = atom2Remove[2];
		xev.data.l[2] = atom2Remove[3];
		XSendEvent(window->x11AppDisplay(), DefaultRootWindow(window->x11AppDisplay()), false, SubstructureNotifyMask, (XEvent *) &xev );
	}

	// Now add:
	xev.data.l[0] = _NET_WM_STATE_ADD;
	xev.data.l[1] = atom2Add[0];
	xev.data.l[2] = atom2Add[1];
	XSendEvent(window->x11AppDisplay(), DefaultRootWindow(window->x11AppDisplay()), false, SubstructureNotifyMask, (XEvent *) &xev );
	if(num2Add > 2) {
		xev.data.l[1] = atom2Add[2];
		xev.data.l[2] = atom2Add[3];
		XSendEvent(window->x11AppDisplay(), DefaultRootWindow(window->x11AppDisplay()), false, SubstructureNotifyMask, (XEvent *) &xev );
	}
	
}

void X11Rt::setClassName(QWidget *window, QString c, QString n) {
	XClassHint arg = {(char *) n.ascii(), (char *) c.ascii()};
	XSetClassHint(window->x11AppDisplay(), window->winId(), &arg);
}

void X11Rt::setBackgroundPixmap(QTextEdit *TEdit, QColor c) {
	/* *** This routine is not used. It was an attempt to make pseudotransparency
	***** on notes - but I failed to obtain the bacjground image from X :-(
	***** If anyone knows the proper way, please write a few lines of code and
	***** send it to me. Regards Jørn
	*****/
	
	/*XImage *xim = XGetImage(TEdit->x11AppDisplay(), DefaultRootWindow(TEdit->x11AppDisplay()), 
		TEdit->x(), TEdit->y(), TEdit->width(), TEdit->height(), -1, ZPixmap);*/

/*
	Pixmap tmp = XCreatePixmap(TEdit->x11AppDisplay(), DefaultRootWindow(TEdit->x11AppDisplay()), TEdit->width(), TEdit->height(), 16);
	//Pixmap ximg = XGetImage(xdisplay, pix, x, y, w, h, -1, ZPixmap);

	XImage *xim = XGetImage(TEdit->x11AppDisplay(), tmp, 
		TEdit->x(), TEdit->y(), TEdit->width(), TEdit->height(), (1 << sizeof(long unsigned int)) - 1, ZPixmap);
	*/
	
	/*
	ximg = get_shm_image (xdisplay, shminfo, x, y, w, h, depth, pix);
    if (!ximg)
		ximg = XGetImage (xdisplay, pix, x, y, w, h, -1, ZPixmap);
	*/
        
	/*
	unsigned long l;
	
	unsigned char rawData[xim->height][xim->width];
	for(int i = 0; i < xim->width; i++) {
		for(int j = 0; j < xim->height; j++) {
			l = XGetPixel(xim, i, j);
			rawData[j][i] = (unsigned char) (l / (1 << 8));
			//fprintf(stderr, "%d ", l);
		}
		//fprintf(stderr, "\n");
	}
	
	
	qWarning("Image data:\nWidth %d\nheight %d\noffset %d\nformat %d", xim->width, xim->height,xim->xoffset,xim->format);
	qWarning("byte_order %d\nbitmap_unit %d\norder %d\npad %d\ndepth %d\nbytes_per_line %d\nbits_per_pixel %d", 
		xim->byte_order, xim->bitmap_unit, xim->bitmap_bit_order, xim->bitmap_pad, xim->depth, xim->bytes_per_line, xim->bits_per_pixel);
	//qWarning("red mask %d\ngreen mask %d\nblue mask %d\n", xim->red_mask, xim->green_mask, xim->blue_mask);		
		
	//QPixmap bgPixmap((const char *) xim);
	//QPixmap bgPixmap_save(QPixmap::grabWidget(QApplication::desktop()->screen(QApplication::desktop()->primaryScreen()),x(),y(), width(), height()));
	//QPixmap bgPixmap(QImage((uchar *)rawData, xim->width, xim->height, xim->depth, (QRgb*) 0, 1 << xim->bits_per_pixel, QImage::LittleEndian));
	qWarning("setting up pixmap.");
	QImage bgImage(*rawData, xim->width, xim->height, sizeof(unsigned long), (QRgb *) 0, 1 << sizeof(unsigned long), QImage::LittleEndian);
	
	QPixmap bgPixmap(bgImage);
	//if(bgPixmap.loadFromData((uchar *) rawData, xim->width * xim->height * sizeof(long)))
		TEdit->setPaper(QBrush(c, bgPixmap));
	//else
		//qWarning("failed");
	//XFreePixmap(TEdit->x11AppDisplay(), xim);
	XDestroyImage(xim);
	*/
}
