#!/bin/sh

function config() {
	NEW="$1"
	OLD="`dirname $NEW`/`basename $NEW .new`"

	# If there's no config file by that name, mv it over:
	if [ ! -r $OLD ]; then
		echo "--- Renaming $NEW to $OLD"
		mv $NEW $OLD
	elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then
		# toss the redundant copy
		echo "--- Deleting $NEW"
		rm $NEW
	else
		# Otherwise, we leave the .new copy for the admin to consider...
		echo "--- Leaving $NEW for you to replace $OLD"
	fi


}

for i in /etc/*.new /etc/cron.daily/*.new
do
	if [ -f $i ]
	then
		config $i
	fi
done

cat << EOF 

WARNING:  Please do not run tmpreaper on /.  There are no protections
 against this written into the program, as that would prevent it from
 functioning the way you'd expect it to in a chroot(8) environment.

 The daily tmpreaper run can be configured through /etc/tmpreaper.conf
 and must be enabled with chmod +x /etc/cron.daily/tmpreaper

EOF
