#!/bin/sh

###
# Use rc.local to start virtualbox at boot.
###

# if rc.vboxdrv is executable, run it on startup
run=`grep "sh /etc/rc.d/rc.vboxdrv" etc/rc.d/rc.local`
if [[ "${run}" == "" ]]; then
cat << EOF >> etc/rc.d/rc.local

#VirtualBox driver
# To disable VirtualBox driver, chmod rc.vboxdrv to 644
if [ -x /etc/rc.d/rc.vboxdrv ]; then
        sh /etc/rc.d/rc.vboxdrv start
fi
EOF
fi

# if rc.vboxnet is executable, run it on startup
run=`grep "sh /etc/rc.d/rc.vboxnet" etc/rc.d/rc.local`
if [[ "${run}" == "" ]]; then
cat << EOF >> etc/rc.d/rc.local

#VirtualBox network
# To disable VirtualBox network, chmod rc.vboxnet to 644
if [ -x /etc/rc.d/rc.vboxnet ]; then
        sh /etc/rc.d/rc.vboxnet start
fi
EOF
fi

# if rc.vboxbridge is executable, run it on startup
run=`grep "sh /etc/rc.d/rc.vboxbridge" etc/rc.d/rc.local`
if [[ "${run}" == "" ]]; then
cat << EOF >> etc/rc.d/rc.local

#VirtualBox bridge
# To enable VirtualBox network, chmod rc.vboxbridge to 755
if [ -x /etc/rc.d/rc.vboxbridge ]; then
        sh /etc/rc.d/rc.vboxbridge start 1 user
fi
EOF
fi

chroot . <<EOR 2>/dev/null
/usr/sbin/groupadd -g215 vboxusers 2> /dev/null

echo "********************************************************************************"
echo "* Remember to run '/etc/rc.d/rc.vboxdrv setup' after install                   *"
echo "*                                                                              *"
echo "* To enable bridged networking change the execution permissions of             *"
echo "* /etc/rc.d/rc.vboxbridge and modify rc.local line to match your number of     *"
echo "* machines and the user running virtualbox.                                    *"
echo "* rc.vboxbridge {start [number of virtual interfaces] [user] | stop}           *"
echo "*                                                                              *"
echo "* This package is the qt3 interface, if you want the new qt4 gui you have to   *"
echo "* install the virtualbox-ose-qt4 package.                                      *"
echo "********************************************************************************"
( cd usr/bin ; rm -rf vboxheadless )
( cd usr/bin ; ln -sf ../lib/virtualbox/VBox.sh vboxheadless )
( cd usr/bin ; rm -rf vboxmanage )
( cd usr/bin ; ln -sf ../lib/virtualbox/VBox.sh vboxmanage )
( cd usr/bin ; rm -rf vboxsdl )
( cd usr/bin ; ln -sf ../lib/virtualbox/VBox.sh vboxsdl )
( cd usr/bin ; rm -rf virtualbox3 )
( cd usr/bin ; ln -sf ../lib/virtualbox/VBox.sh virtualbox3 )
