/***************************************************************************
 *   Copyright (C) 2005 by Oleg Martemjanov                                *
 *   demogorgorn@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "direntry.h"

#include <algorithm>

using namespace std;

DirEntry::DirEntry()
{
}

DirEntry::DirEntry(const QString &directoryName)
{
	myDirName = directoryName;
	
}

void DirEntry::appendEntry(FileEntry m_fileentry)
{
	m_filesList.append(m_fileentry);
}

QString DirEntry::getEntryTitle(int i) const
{
	return m_filesList[i].title();
}

QString DirEntry::getEntryFilename(int i) const
{
	return m_filesList[i].filename();
}

QString DirEntry::getReadyLink(int i) const
{
	QString link = "<a href=\"" + m_filesList[i].filename() + "\">" + m_filesList[i].title() + "</a>";
	
	return link;
}

int DirEntry::getListSize() const
{
	return (int)m_filesList.size();
}

bool DirEntry::directoryIsEmpty() const
{
	if (m_filesList.isEmpty())
		return true;
	else
		return false;
}

void DirEntry::sortList()
{
	sort( m_filesList.begin(), m_filesList.end() );
}




 
 
