/***************************************************************************
 *   Copyright (C) 2005 by Oleg Martemjanov                                *
 *   demogorgorn@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _DIRENTRY_H_
#define _DIRENTRY_H_

#include "fileentry.h"
#include "utils.h"

#include <qvaluevector.h>

class DirEntry
{
public:
	DirEntry();
	DirEntry(const QString &directoryName);
	
	QString directoryName() const { return myDirName; }
	void setDirectory(const QString &directoryName) { myDirName = directoryName; }
	
	void appendEntry(FileEntry m_fileentry);
	
	QString getEntryTitle(int i) const;
	QString getEntryFilename(int i) const;
	QString getReadyLink(int i) const;
	
	bool directoryIsEmpty() const;
		
	int getListSize() const;
	
	void sortList();
	
	QValueVector<FileEntry> m_filesList;

private:
	QString myDirName;

};

#endif



