/***************************************************************************
 *   Copyright (C) 2005 by Oleg Martemjanov                                *
 *   demogorgorn@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _FILEENTRY_H_
#define _FILEENTRY_H_

#include <qstring.h>

class FileEntry 
{ 
public: 
  FileEntry(const QString &filename = "", const QString &title = ""); 
  
  QString filename() const { return myFilename; }
  void setFilename(const QString &filename) { myFilename = filename; }
  
  QString title() const { return myTitle; } 
  void setTitle(const QString &title) { myTitle = title; } 
   
private: 
  QString myFilename;
  QString myTitle; 
};

int operator==(const FileEntry &fileentry1, const FileEntry &fileentry2); 
int operator<(const FileEntry &fileentry1, const FileEntry &fileentry2);

#endif

