/***************************************************************************
 *   Copyright (C) 2005 by Oleg Martemjanov                                *
 *   demogorgorn@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _INDEXTAB_H_
#define _INDEXTAB_H_

// our includes
#include "utils.h"
#include "direntry.h"
#include "fileentry.h"

#include <qwidget.h>
#include <qstring.h>
#include <qvaluevector.h>

#include <kconfig.h>

#include <algorithm>
#include <iostream>

using namespace std;

class QCheckBox;
class QRadioButton;
class KLineEdit;
class KDirRequester;
class KPushButton;
class KTextEdit;
class KURLRequester;

class IndexTab : public QWidget
{
	Q_OBJECT
public:
	IndexTab(QWidget *p = 0, const char *name = 0);
	~IndexTab() { saveSettings(); }
	
	// values
	QString directoryName() const;  // index directory name
	QString resultFile() const;     // result file name
	QString fileTypes() const;      // file types to index
	QString homeDir() const;        // home directory
	QString styleSheet() const;     // file to use as
	QString deliMeter() const;      // <br> or <p/>
	
	QString titleFrom() const;
	QString titleTo() const;
	
	bool useTable() const;
	bool recurSive() const;
	bool dntEnterFilesDir() const;
	bool indexByWord() const;
	bool dntWriteFolderNames() const;
	QString indexWord() const;
	
	bool sortingDirs() const;
	
	bool showResult() const;
	bool closeApp() const;
	
	QString browserApp() const;
	
private:
	QValueVector<DirEntry> m_dirList;
	
	KConfig *config;

private:
	void setupPages();
	void setupPage1();
	void setupPage2();
	void setupPage3();
	void setupPage4();
	void setupPage5();
	
	void connectSlots();
	
private slots:
	void indexDir();
	void startIndexing(const QString &dirName);
	void savePage();

	QString getTitle(const QString& filename);
	
	bool checkDepends();
	
	void writeTable(QTextStream &m_stream);
	void writeSimpleLayout(QTextStream &m_stream);
	
private slots:
	void slotHtmlTypes();
	void slotOtherTypes();
	
	void slotUseDetection();
	void slotIndexWordClicked();
	
	void slotDelimBrClicked();
	void slotDelimPClicked();
	void slotWriteTableClicked();
	
	void slotOpenPage();
	
	void loadSettings();
	void saveSettings();
	
protected:
	QWidget* parent;
	QWidget* page_1;
	QWidget* page_2;
	QWidget* page_3;
	QWidget* page_4;
	QWidget* page_5;
	
	// Directory tab
	KDirRequester *m_dirPathReq;
	QCheckBox *m_writeNamesCb;
	QCheckBox *m_dntEnterCb;
	QCheckBox *m_recursiveCb;
	QCheckBox *m_sortDirsCb;
	
	// File Types tab
	QRadioButton *m_htmlDocsRb;
	QRadioButton *m_otherDocsRb;
	KTextEdit *m_otherDocsEdit;
	
	// HTML document tab
	KLineEdit *m_titleFEdit;
	KLineEdit *m_titleTEdit;
	QCheckBox *m_removeILLCharsCb;
	QCheckBox *m_removeIncTagsCb;
	QCheckBox *m_useDetectEncCb;
	QCheckBox *m_indexContainCb;
	KLineEdit *m_indexContainEdit;
	
	// Result page tab
	KURLRequester *m_resultPageReq;
	QCheckBox *m_dotableCb;
	QRadioButton *m_brDelimeterRb;
	QRadioButton *m_pDelimeterRb;
	QCheckBox *m_useStylesheetCb;
	KURLRequester *m_stylesheetReq;
	
	// Index tab
	QCheckBox *m_showPageCb;
	QCheckBox *m_closeAppCb;
	KPushButton *m_indexBtn;
};

#endif






