/***************************************************************************
 *   Copyright (C) 2005 by Oleg Martemjanov                                *
 *   demogorgorn@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "webpageindexer.h"
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kmessagebox.h>

// OS includes
#include <unistd.h>
#include <sys/types.h>

// description
static const char description[] =
    I18N_NOOP("WebPageIndexer is an indexing / renaming tool for KDE.\n\n"
	       "If you like this program please write letter to the author.\n"
	       "He likes to talk with the users!");

static const char version[] = "0.3";

static KCmdLineOptions options[] =
{
//    { "+[URL]", I18N_NOOP( "Document to open" ), 0 },
	{ "index",  I18N_NOOP("program will work in index mode"), 0 },
	{ "rename",  I18N_NOOP("program will work in rename mode"), 0 },
	{ "r +[dir]", I18N_NOOP("add directory recursively"), 0 },
	KCmdLineLastOption
};

int main(int argc, char **argv)
{
	KAboutData about("webpageindexer", I18N_NOOP("WebPageIndexer"), version, description,
		KAboutData::License_GPL_V2,"Build: " __DATE__ " " __TIME__ , 
		"(C) 2005 Martemjanov Oleg Anatoljevich", "http://wpi.sourceforge.net",
		"demogorgorn@gmail.com");
		
	about.addAuthor( "Martemjanov Oleg Anatoljevich", "Maintainer and Idea founder.", 
                     "demogorgorn@gmail.com", "http://wpi.sourceforge.net" );
	
	about.addCredit( "Linux.org.ru (LOR)","For posting news about new release.",0,"http://www.linux.org.ru");
	
	about.addCredit( "KDE Team","For excellent DE.",0,"http://www.kde.org");
	
	about.addCredit( "Trolltech Team","For excellent ToolKit.",0,"http://www.trolltech.com");
	
	// end about data
	KCmdLineArgs::init(argc, argv, &about);
	KCmdLineArgs::addCmdLineOptions( options );
	KApplication app;
	
	WebPageIndexer *mainWin = 0;

    if (app.isRestored())
    {
        RESTORE(WebPageIndexer);
    }
    else
    {
        // no session.. just start up normally
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

        /// @todo do something with the command line args here

        mainWin = new WebPageIndexer();
        app.setMainWidget( mainWin );
        mainWin->show();

        args->clear();
    }
    
	// show Warning message if app is running under root
	unsigned int uid = geteuid();
	if( uid == 0 )
        KMessageBox::information( 0, i18n(
            "<b>WebPageIndexer was started from root!</b><br>"
            "When started from root, WebPageIndexer may damage your "
            "system if you do not know exactly what you are "
            "doing!"
        ), i18n("Error"), "WPI Root Warning" );

    // mainWin has WDestructiveClose flag by default, so it will delete itself.
    return app.exec();
}

