/***************************************************************************
 *   Copyright (C) 2005 by Oleg Martemjanov                                *
 *   demogorgorn@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "optionsdialog.h"
#include <kcombobox.h>
#include <kconfig.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kpushbutton.h>

#include <qlayout.h>
#include <qlabel.h>

OptionsDialog::OptionsDialog(QWidget *parent, const char *name) :
	KDialog(parent,name)
{
	setCaption(i18n("Preferences"));
	
	config = KGlobal::config();
	
	QVBoxLayout *pageLayout = new QVBoxLayout( this, 11, 1 );
	
	QLabel *brLabel = new QLabel(this);
	brLabel->setText(i18n("Preffered browser:"));
	
	browserBox = new KComboBox(true,this);
	browserBox->insertItem(SmallIcon("html"),"firefox");
	browserBox->insertItem(SmallIcon("html"),"opera");
	browserBox->insertItem(SmallIcon("html"),"mozilla");
	browserBox->insertItem(SmallIcon("html"),"konqueror");
	browserBox->insertItem(SmallIcon("html"),"epiphany");
	browserBox->insertItem(SmallIcon("html"),"galeon");
	browserBox->insertItem(SmallIcon("html"),"netscape");
	browserBox->insertItem(SmallIcon("html"),"dillo");
	
	QLabel *fmLabel = new QLabel(this);
	fmLabel->setText(i18n("Preffered file manager:"));
	
	fmCombo = new KComboBox(true,this);
	fmCombo->insertItem(SmallIcon("kugar_kud"),"krusader");
	fmCombo->insertItem(SmallIcon("kugar_kud"),"rox");
	fmCombo->insertItem(SmallIcon("kugar_kud"),"rox-filer");
	fmCombo->insertItem(SmallIcon("kugar_kud"),"konqueror");
	fmCombo->insertItem(SmallIcon("kugar_kud"),"nautilus");
	
	QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
	
	KPushButton *okButton = new KPushButton( SmallIcon("button_ok"), i18n("OK"),this);
	KPushButton *cancButton = new KPushButton( SmallIcon("button_cancel"), i18n("Cancel"),this);
	
	QSpacerItem* spacer1 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
	
	QHBoxLayout *horLay1 = new QHBoxLayout();
	horLay1->addItem( spacer1 );
        horLay1->addWidget( okButton );
	horLay1->addWidget( cancButton );
	
	pageLayout->addWidget( brLabel );
	pageLayout->addWidget( browserBox );
	pageLayout->addWidget( fmLabel );
	pageLayout->addWidget( fmCombo );
	pageLayout->addItem( spacer );
	pageLayout->addLayout( horLay1 );
	
	connect( okButton, SIGNAL(clicked()), this, SLOT(slotOkClicked()) );
	connect( cancButton, SIGNAL(clicked()), this, SLOT(slotCancClicked()) );
	
	loadSettings();
	
	
}

void OptionsDialog::loadSettings()
{
	config->setGroup("Programs");
	browserBox->setCurrentText( config->readEntry("Browser", "firefox") );
	fmCombo->setCurrentText( config->readEntry("FM","konqueror") );
}

void OptionsDialog::slotOkClicked()
{
	config->setGroup("Programs");
	config->writeEntry("Browser",browserBox->currentText());
	config->writeEntry("FM",fmCombo->currentText());
	config->sync();
	
	close();

}

void OptionsDialog::slotCancClicked()
{
	close();
}



