/***************************************************************************
 *   Copyright (C) 2005 by Oleg Martemjanov                                *
 *   demogorgorn@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _RENAMETAB_H_
#define _RENAMETAB_H_

// our includes
#include "utils.h"

#include <qwidget.h>
#include <qstring.h>

#include <kconfig.h>

class KDirRequester;
class QCheckBox;
class QRadioButton;
class KPushButton;
class KTextEdit;
class RenameTab : public QWidget
{
	Q_OBJECT
public:
	RenameTab(QWidget *p = 0, const char *name = 0);
	~RenameTab() { saveSettings(); }
	
	bool recursive() const;
	bool dontEnterFilesDir() const;
	QString fileTypes() const;
	QString directoryName() const;
	bool removeIllegalChars() const;
	bool removeIncludedTags() const;
	bool replaceSpaces() const;
	QString fmApp() const;
	bool showDir() const;
	
	

private:
	void connectSlots();
	void setupPage1();
	void setupPage2();
	void setupPage3();
	void setupPage4();
	
	KConfig *config;
private slots:
	void renameDir();
	void startRenaming(const QString &dirName);
	
	QString getTitle(const QString& filename);
	
private slots:
	void slotHtmlTypes();
	void slotOtherTypes();
	
	void slotOpenDir();
	
	void loadSettings();
	void saveSettings();

protected:
	QWidget* parent;
	QWidget* page_1;
	QWidget* page_2;
	QWidget* page_3;
	QWidget* page_4;
	
	KDirRequester *m_renameDirReq;
	QCheckBox *m_recursiveCb;
	QCheckBox *m_dntEnterFilesDirCb;
	
	// File Types tab
	QRadioButton *m_htmlDocsRb;
	QRadioButton *m_otherDocsRb;
	KTextEdit *m_otherDocsEdit;
	
	// doc
	QCheckBox *m_removeILLCharsCb;
	QCheckBox *m_removeIncTagsCb;
	QCheckBox *m_replaceSpacesCb;
	
	// rename
	QCheckBox *m_showDirCb;
	QCheckBox *m_closeAppCb;
	KPushButton *m_renameBtn;
	
	

};

#endif

