/***************************************************************************
 *   Copyright (C) 2005 by Oleg Martemjanov                                *
 *   demogorgorn@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _UTILS_H_
#define _UTILS_H_

#include <qstring.h>
#include <stdio.h>
 
static inline QString getEncoding(const QString& filename) 
{
	QString com_enca("enca");
	com_enca += " -e '" + filename + "'";
 
	FILE *enca = popen( com_enca.local8Bit(), "r");
	char outstr[80];
	fgets(outstr, 80, enca);
	pclose(enca);
	QString cp( outstr );
	cp = cp.stripWhiteSpace();
	int pozslash;
	if ( (pozslash = cp.find( '/' )) != -1 )
		cp = cp.left( pozslash );

	if (cp != "KOI8-R" && cp != "CP1251" && cp != "KOI8-U" && cp != "UTF-8" && cp != "IBM866" ) 
	{
		cp = "UTF-8";
	}

	return cp;
}

#endif
