/***************************************************************************
 *   Copyright (C) 2005 by Oleg Martemjanov                                *
 *   demogorgorn@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "variouswidgets.h"

#include <qlayout.h>
#include <qframe.h>
#include <klineedit.h>
#include <kpushbutton.h>
#include <kiconloader.h>
#include <kdirselectdialog.h>

KDirRequester::KDirRequester(QWidget *parent, const char *name) :
	QWidget(parent, name) 
{
	QGridLayout *gboxW = new QGridLayout( this, 1, 1, 2, 2, "LayoutW");
	gboxW->setAlignment(Qt::AlignTop);

	dirEdit = new KLineEdit(this);
	gboxW->addWidget(dirEdit,1,0);

	dirButton = new KPushButton(this);
	dirButton->setMinimumSize(QSize(24,24));
	dirButton->setMaximumSize(QSize(24,24));
	dirButton->setPixmap(SmallIcon("fileopen"));
	connect(dirButton, SIGNAL(clicked()),this,SLOT(chooseDir()));
	gboxW->addWidget(dirButton,1,1);
}

KDirRequester::~ KDirRequester() 
{

}

void KDirRequester::chooseDir() 
{
	KDirSelectDialog dia;
	dia.exec();
	if (!dia.url().isEmpty()) dirEdit->setText(dia.url().path());
}






 
 
 