/*
 * Copyright (C) 2004, 2005, 2007 Moritz Orbach <zufall@apfelboymchen.homeunix.net>
 *
 * Zufall is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Zufall is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Parts of this file are ripped from Esetroot.c written by Nat Friedman 
 * <ndf@mit.edu> with modifications by Gerald Britton <gbritton@mit.edu> and 
 * Michael Jennings <mej@eterm.org>
 *
 * $Id: getprop.c,v 1.3 2007/12/19 10:39:46 mori Exp $
 *
 */

#include <stdio.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

Display *Xdisplay = NULL;
Screen *scr;
Window Xroot;
int screen;

void
set_pixmap_property(Pixmap p)
{

    Atom prop_root, prop_esetroot, type;
    int format;
    unsigned long length, after;
    unsigned char *data_root, *data_esetroot;
    int debug=1;

    prop_root = XInternAtom(Xdisplay, "_XROOTPMAP_ID", True);
    prop_esetroot = XInternAtom(Xdisplay, "ESETROOT_PMAP_ID", True);

    if (debug) {
        fprintf(stderr, "%s:%d:  set_pixmap_property(0x%08x):  prop_root == 0x%08x, prop_esetroot == 0x%08x\n", __FILE__, __LINE__,
                (unsigned int) p, (unsigned int) prop_root, (unsigned int) prop_esetroot);
    }
    if (prop_root != None && prop_esetroot != None) {
        XGetWindowProperty(Xdisplay, Xroot, prop_root, 0L, 1L, False, AnyPropertyType, &type, &format, &length, &after, &data_root);
        if (type == XA_PIXMAP) {
            XGetWindowProperty(Xdisplay, Xroot, prop_esetroot, 0L, 1L, False, AnyPropertyType, &type, &format, &length, &after,
                               &data_esetroot);
            if (data_root && data_esetroot) {
                if (type == XA_PIXMAP && *((Pixmap *) data_root) == *((Pixmap *) data_esetroot)) {
                    XKillClient(Xdisplay, *((Pixmap *) data_root));
                }
            }
        }
    }
    /* This will locate the property, creating it if it doesn't exist */
    prop_root = XInternAtom(Xdisplay, "_XROOTPMAP_ID", False);
    prop_esetroot = XInternAtom(Xdisplay, "ESETROOT_PMAP_ID", False);

    /* The call above should have created it.  If that failed, we can't continue. */
    if (prop_root == None || prop_esetroot == None) {
        fprintf(stderr, "Esetroot:  creation of pixmap property failed.\n");
        exit(1);
    }
    XChangeProperty(Xdisplay, Xroot, prop_root, XA_PIXMAP, 32, PropModeReplace, (unsigned char *) &p, 1);
    XChangeProperty(Xdisplay, Xroot, prop_esetroot, XA_PIXMAP, 32, PropModeReplace, (unsigned char *) &p, 1);
    fprintf(stderr, "%s:%d:  set_pixmap_property(0x%08x):  _XROOTPMAP_ID and ESETROOT_PMAP_ID set to 0x%08x.\n", __FILE__, __LINE__, (unsigned int) p, (unsigned int) p);
    XSetCloseDownMode(Xdisplay, RetainPermanent);
    XFlush(Xdisplay);
}

void initX(void)
{
	/* clients without windows don't appear in xlsclients */
	Xdisplay = XOpenDisplay(NULL);
	if (!Xdisplay) {
		fprintf(stderr, "%s: Unable to open display\n", "descht");
		exit(1);
	}

	screen = DefaultScreen(Xdisplay);
	Xroot = RootWindow(Xdisplay, screen);
	scr = ScreenOfDisplay(Xdisplay, screen);
}

void showpixmaps(Display *Xdisplay, Window Xroot)
{
	Atom prop_root, prop_esetroot, type;
	int format;
	unsigned long length, after;
	unsigned char *data;
	Pixmap p;

	prop_root = XInternAtom(Xdisplay, "_XROOTPMAP_ID", True);
	prop_esetroot = XInternAtom(Xdisplay, "ESETROOT_PMAP_ID", True);

	XGetWindowProperty(Xdisplay, Xroot, prop_root, 0L, 1L, False, AnyPropertyType, &type, &format, &length, &after, &data);
	if (data) {
		p = *((Pixmap *)data);
		fprintf(stderr, "xroot   : %p\n", p);
	}
	XGetWindowProperty(Xdisplay, Xroot, prop_esetroot, 0L, 1L, False, AnyPropertyType, &type, &format, &length, &after, &data);
	if (data) {
		p = *((Pixmap *)data);
		fprintf(stderr, "esetroot: %p\n", p);
	}
}

int main(int argc, char *argv[])
{
	initX();

	showpixmaps(Xdisplay, Xroot);

	XCloseDisplay(Xdisplay);
}

