/*
 * Copyright (C) 2004, 2005, 2007 Moritz Orbach <zufall@apfelboymchen.homeunix.net>
 *
 * Zufall is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Zufall is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * $Id: list.c,v 1.3 2007/12/19 10:39:47 mori Exp $
 *
 */

#include <stdio.h>
#include <string.h>

#include "config.h"

#include "memman.h"

#ifdef FENCE
#include "efence.h"
#endif

typedef struct s_knot {
	struct s_knot *pnext;
	unsigned int datasize;
	void *data;
} t_knot;

typedef struct s_list {
	int count;
	t_knot *pfirst;
	t_knot *plast;
	/* optmimization for sequential access */
	int listpos;
	t_knot *plistpos;
} t_list;

/* returns address of new initialized node */
t_knot *knot_init(void)
{
	t_knot *knot;

	knot = getmem(sizeof(t_knot));
	knot->pnext = NULL;
	knot->data = NULL;
	knot->datasize = 0;

	return(knot);
}

/* returns adress of new initialized list */
t_list *list_init(void)
{
	t_list *list;

	list = getmem(sizeof(t_list));
	list->count = 0;
	list->pfirst = knot_init();
	list->plast = list->pfirst;
	list->plistpos = list->pfirst;
	list->listpos = 0;

	return list;
}

int list_count(t_list *list)
{
	return(list->count);
}

/* first knot is 1 */
t_knot *list_getknot(t_list *list, int num)
{
	t_knot *pcurrent;
	int pos = 1;
	int ok = 1;
	int listcount;

	listcount = list->count;

	if (listcount == 0) {
		fprintf(stderr, "list is empty!\n");
		ok = 0;
	}

	if (num > listcount) {
		fprintf(stderr, "huh? knoten %d? ich hab doch nur %d?!\n", num, listcount);
		ok = 0;
	}

	if (ok) {

		if (num > list->listpos && list->listpos > 1) {
			/* don't start at the beginning is there is a later point saved */
			pos = list->listpos;
			pcurrent = list->plistpos;
		}
		else
			/* start from the beginning */
			pcurrent = list->pfirst;

		while (pcurrent->pnext != NULL && pos < num) {
			pcurrent = pcurrent->pnext;
			pos++;
		}

		/* save new position */
		list->listpos = pos;
		list->plistpos = pcurrent;
	}

	if (ok)
		return pcurrent;
	else
		return NULL;
}

int list_append(t_list *list, const void *data, unsigned int datasize)
{
	t_knot *pcurrent = list->plast;
	t_knot *pnew;

	if (pcurrent == NULL) {
		printf("HMMMMM........\n");
		return 0;
	}

	if (pcurrent->data != NULL) {
		/* besetzt */
		pnew = knot_init();
		pcurrent->pnext = pnew;
		pcurrent = pnew;
	}
	pcurrent->data = getmem(datasize);
	pcurrent->datasize = datasize;

	memcpy(pcurrent->data, data, datasize);
	list->count++;
	list->plast = pcurrent;

	return 1;
}

/* delete one node */
int list_delete(t_list *list, unsigned int pos)
{
	t_knot *pdelete, *pprev;
	int listcount, ok = 1;

	listcount = list->count;
	if (pos > listcount) {
		fprintf(stderr, "huh? knoten %d loeschen? ich hab doch nur %d?!\n", pos, listcount);
		ok = 0;
	}

	if (ok && pos > 1) {
		/* vorherigen knoten finden */
		pprev = list_getknot(list, pos-1);
		ok = pprev != NULL;

		/* knoten zum lschen finden */
		if (ok) {
			pdelete = pprev->pnext;
			ok = pdelete != NULL;
		}

		/*
		 * vorherigen und nchsten verbinden, free mem
		 * nchster kann ruhig NULL sein
		 */
		if (ok) {
			pprev->pnext = pdelete->pnext;
			freemem(pdelete->data, pdelete->datasize);
			freemem(pdelete, sizeof(t_knot));
		}
		if (pos == list->count)
			list->plast = pprev;
	}
	
	/* first node */
	if (ok && pos == 1) {
		pdelete = list_getknot(list, pos);
		ok = pdelete != NULL;

		if (list->count > 1) {
			/* first, but not last reamaining node */
			if (ok) {
				list->pfirst = pdelete->pnext;
				freemem(pdelete->data, pdelete->datasize);
				freemem(pdelete, sizeof(t_knot));
			} else printf("das drfte nu echt nicht passieren!\n");
		} else {
			/* gleichzeitig letzter knoten - nur daten lschen, sonst msste man neu initialisieren */
			freemem(pdelete->data, pdelete->datasize);
			pdelete->data = NULL;
		}
	}

	if (ok) {
		list->count--;
	}

	/* listpos is invalid now */
	list->listpos = 0;

	return(ok);
}

/* delete the list */
int list_destroy(t_list *list)
{
	int ok = 1;

	for (; list->count > 0; ) {
		if (!list_delete(list, 1))
		{
			printf("not ok!\n");
			ok = 0;
			break;
		}
	}

	/* delete memory for the first node */
	freemem(list->pfirst, sizeof(t_knot));
	/* delete memory for the list */
	freemem(list, sizeof(t_list));

	list = NULL;
	return ok;
}

void *list_get(t_list *list, int num)
{
	t_knot *knot;

	knot = list_getknot(list, num);

	if (knot != NULL)
		return knot->data;
	else
		return NULL;

}

unsigned int list_allocated(void)
{
	return allocated();
}
