/*
 * Copyright (C) 2004, 2005, 2007 Moritz Orbach <zufall@apfelboymchen.homeunix.net>
 *
 * Zufall is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Zufall is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * $Id: list.h,v 1.4 2007/12/27 14:16:39 mori Exp $
 *
 */

typedef struct s_knot {
	struct s_knot *pnext;
	unsigned int datasize;
	void *data;
} t_knot;

typedef struct s_list {
	int count;
	t_knot *pfirst;
} t_list;

extern t_list *list_init(void);
extern void *list_get(t_list *list, int num);
extern int list_append(t_list *list, const void *data, unsigned int datasize);
extern int list_count(t_list *list);
extern int list_delete(t_list *list, unsigned int pos);
extern int list_destroy(t_list *list);
extern unsigned int list_allocated(void);
