/*
 * Copyright (C) 2004, 2005, 2007 Moritz Orbach <zufall@apfelboymchen.homeunix.net>
 *
 * Zufall is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Zufall is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * $Id: memman.c,v 1.4 2007/12/27 17:34:24 mori Exp $
 *
 */

#include <stdio.h>
#include <stdlib.h>

/* fr strerror und errno */
#include <errno.h>

#include "config.h"

#ifdef DEBUG
#include "memwatch.h"
#define malloc mmalloc
#define free mfree
#define realloc mrealloc
#endif

#ifdef FENCE
#include "efence.h"
#endif

size_t ballocated = 0;


size_t allocated(void)
{
	return(ballocated);
}

void *extendmem(void *p, size_t size, int delta) {
	
	/* don't care about the original value of p, failing is fatal anyway */
	p = realloc(p, size);
	if (p == NULL) {
		perror("realloc");
		exit (2);
	}
	ballocated += delta;
	return p;
}

/* typischer name wre anscheinend `xmalloc' (info libc) */
void *getmem(size_t size)
{
	void *p;

	p = malloc(size);
	if (p == NULL) {
		perror("malloc");
		exit (2);
	}
	ballocated += size;
	return p;
}

void freemem(void *pointer, size_t size)
{
	free(pointer);
	pointer = NULL;
	ballocated -= size;
	/* this can't be true if ballocated is unsigned! */
	/* doesn't work anymore because of realloc
	if ((int)ballocated < 0) {
		fprintf(stderr, "mehr speicher freigegeben als geholt?? PANIK! %d\n", ballocated);
		exit(2);
	}
	*/
}
