/*
 * Copyright (C) 2004, 2005, 2007 Moritz Orbach <zufall@apfelboymchen.homeunix.net>
 *
 * Zufall is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Zufall is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * $Id: memwatch.c,v 1.3 2007/12/19 10:39:47 mori Exp $
 *
 */
#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>

FILE *fpmalloc, *fpfree;
const char *mallog = "malloc.log";
const char *freelog = "free.log";

void memwatchstop(void)
{
	fclose(fpmalloc);
	fclose(fpfree);
}

void memwatchstart(void)
{
	fpmalloc = fopen(mallog, "w");
	if (fpmalloc == NULL) {
		printf("memwatch: could not open file\n");
		exit(1);
	}

	fpfree = fopen(freelog, "w");
	if (fpfree == NULL) {
		printf("memwatch: could not open file\n");
		exit(1);
	}
}

void *mmalloc(size_t size)
{
	void *temp = NULL;

	if (fpmalloc == NULL) memwatchstart();

	temp = malloc(size);
	fprintf(fpmalloc, "%p", temp);
	if (temp != NULL)
		fprintf(fpmalloc, "\n");
	else
		fprintf(fpmalloc, "\tkacke.");

	fflush(fpmalloc);
	return temp;

}

void *mrealloc(void *p, size_t size)
{
	void *temp = p;

	temp = realloc(temp, size);

	if (temp == NULL) {
		fprintf(fpmalloc, "\trealloc kacke.\n");
			/*
		if (p != temp)
			fprintf(fpmalloc, "realloc %p to %p\n", p, temp);
			*/
	}

	p = temp;
	return p;
}

void mfree(void *ptr)
{
	fprintf(fpfree, "%p\n", ptr);
	free(ptr);
	ptr = NULL;
	fflush(fpfree);
}

