//
// C++ Implementation: kpgaggregatesfolder
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgaggregatesfolder.h"

// include files for KDE
#include <kdebug.h>
#include <klocale.h>

#include "kpgconnection.h"
#include "kpgschema.h"
#include "kpgaggregate.h"

KPGAggregatesFolder::KPGAggregatesFolder(KPGSchema *parent, pqxx::oid oidNameSpace)
	: KPGItemsFolder(parent, i18n("Aggregates"), m_pIconFolderYellowClosed, m_pIconFolderYellowOpen)
{
	m_oidNameSpace = oidNameSpace;
}

KPGAggregatesFolder::~KPGAggregatesFolder()
{
}

void KPGAggregatesFolder::refresh() throw(const KPGSqlException &)
{
    // delete all child items (databases)
    while (QListViewItem * pItem = firstChild())
        delete pItem;

	// obtain list of aggregates
    QString strQuery("SELECT pr.proname AS aggrname, aggfnoid::oid AS aggegfnoid, aggfnoid AS aggfnname, pg_get_userbyid(proowner) AS aggrowner, description, aggtransfn::oid AS \
    aggtransfnoid, aggtransfn, aggfinalfn::oid AS aggfinalfnoid, aggfinalfn, "); // proargtypes[0] AS aggbasetype,
		
	strQuery.append("ti.oid AS inputtypoid, ti.typname AS inputtypname, ");
	strQuery.append("tt.oid AS transtypoid, tt.typname AS transtypname, ");
	strQuery.append("tf.oid AS returntypoid, tf.typname AS returntypname, ");
		
	strQuery.append("agginitval ");
	strQuery.append("FROM pg_catalog.pg_aggregate ag ");
	strQuery.append("JOIN pg_catalog.pg_proc pr ON pr.oid = ag.aggfnoid::oid ");
	strQuery.append("JOIN pg_catalog.pg_type ti on ti.oid=pr.proargtypes[0] ");
	strQuery.append("JOIN pg_catalog.pg_type tt on tt.oid=aggtranstype ");
	strQuery.append("JOIN pg_catalog.pg_type tf on tf.oid=prorettype ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_description des ON des.objoid=aggfnoid::oid ");
	strQuery.append("WHERE pr.pronamespace = " + QString("%1").arg(m_oidNameSpace) + " ");
	strQuery.append("ORDER BY aggrname");
			
    try
    {
		KPGConnection *pConnection = connection();
		m_pqxxResultAggregates = pConnection->runQuery(strQuery);

        KPGAggregate *pAggregate = 0;
            
        for (result::size_type i = 0; i != m_pqxxResultAggregates.size(); ++i)
        {
            if(pAggregate == 0)
                pAggregate = new KPGAggregate(this, m_pqxxResultAggregates[i]["aggrname"].c_str());
            else
                pAggregate = new KPGAggregate(this, pAggregate, m_pqxxResultAggregates[i]["aggrname"].c_str());
                
            pAggregate->setProperties(m_pqxxResultAggregates[i], pConnection);
        }
    }
    catch (const std::exception &e)
    {
        kdError() << k_funcinfo << e.what() << endl;
        throw KPGSqlException(e.what(), strQuery);
    } 
}


