/***************************************************************************
                          kpgdatabase.h  -  description
                             -------------------
    begin                : � led 6 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPGDATABASE_H
#define KPGDATABASE_H

#include "kpgobject.h"
#include "kpgconnection.h"

class KPGServer;
class KPGCastsFolder;
class KPGLanguagesFolder;
class KComboBox;

/**
  * The database
  *
  * @author Lumir Vanek
  */
class KPGDatabase : public KPGObject
{
public: 
	KPGDatabase(KPGServer *, const QString, pqxx::oid);
  	KPGDatabase(KPGServer *, KPGDatabase *, const QString, pqxx::oid);
	~KPGDatabase();
    
    virtual eNodeType type() const { return nodeDatabase; }
	
	// Get SQL object type 
  	virtual const char * getObjectType() const { return "DATABASE"; }
	
	virtual bool isSystemObject() const { return m_bIsSystemObject; }
		
	void connectToDB() throw(const std::exception);
	
	void disconnectFromDB();
	
	bool isConnected() const { return (m_pDbConnection != 0); }
  	pqxx::result runQuery(const QString, KPGConnection::ETransType = KPGConnection::eTransNormal);
  
	void setProperties(const pqxx::result::tuple &, bool, bool);
      
    // Return connection to database. All items childs to KPGDatabase tells your parents for connection  
	virtual KPGConnection * connection() const { return m_pDbConnection; }
	
	// Refresh item, ald also childs objects
	void refresh() throw(const KPGSqlException &);
	
	// Refresh only this item, not childs
	void refreshItem() throw(const KPGSqlException &);
	
	// This same behavior as refreshItem(), but for some objects, may be optimalized to run faster
	void smartRefresh() throw(const KPGSqlException &) { return refreshItem(); }
  	
  	const QString connectionString();
	
	// Return pointer to parent DB server
	KPGServer * server() const;
	
	/*
	 * Functions for accessing properties
	 */
	const QString & owner() const { return m_strOwner; }
	const QString & tablespace() const { return m_strTablespace; }
	const QString & encoding() const { return m_strEncoding; }
    const QString & acl() const { return m_strACL; }
    const QString & path() const { return m_strPath; }
    pqxx::oid oidTablespace() const { return m_oidTablespace; }
    bool canCreate() const { return m_bCanCreate; }
    const QString & defaultVariables() const { return m_strDefaultVariables; }
    bool allowConnections() const { return m_bAllowConnections; } 
    bool isTemplate() const { return m_bIsTemplate; }
    long long size() const { return m_llSize; }
    const QString & prettySize() const { return m_strPrettySize; }
    	
	/*
	 * Functions for accessing nested folders
	 */
	KPGCastsFolder * getCastsFolder() const { return m_pFolderCasts; }
	KPGLanguagesFolder * getLanguagesFolder() const { return m_pFolderLanguages; }
	
	/*
	 * Functions for accessing nested results
	 */
	const pqxx::result & resultCasts() const;
	const pqxx::result & resultLanguages() const;
	const pqxx::result & resultSchemas() const;
	const QString queryStatistics() const;
  	const QString queryExtendedStatistics(int) const;
  	
  	const QString queryDiskUsage() const;
  	const QString queryLocks() const;
	
	void fillListOfObjectsForCodeCompletion(KPGOidNameList &);
   
   	bool isConnectionStateChanged() const { return m_bConnectionStateChanged; }
   	void clearConnectionStateChanged() { m_bConnectionStateChanged = false; }
   
    // Return encoder name for QTextCodec regards to connection client encoding
	const QString encoderName() { return m_pDbConnection->encoderName(); }
	    
protected:

  	virtual void activate();

protected:
  	KPGConnection *m_pDbConnection;

	// Set true after connect/disconnect, signals that database list need refresh 
	bool m_bConnectionStateChanged;

  	/*
	 * Properties
	 */
	QString m_strOwner;
	QString m_strACL;
	QString m_strPath;           // For PostgreSQL 7.x or older
	pqxx::oid m_oidTablespace;   // For PostgreSQL 8 or newer 
	QString m_strTablespace;     // For PostgreSQL 8 or newer
	QString	m_strEncoding;
	bool m_bCanCreate;
	QString m_strDefaultVariables;
  	bool m_bAllowConnections;
	bool m_bIsTemplate;
	long long m_llSize;
  	QString m_strPrettySize;
  
  	bool m_bIsSystemObject;
	
	// Folders
	KPGCastsFolder *m_pFolderCasts;
	KPGLanguagesFolder *m_pFolderLanguages;
	
protected:
	// results that will be displayed in properties window
	pqxx::result m_pqxxResultSchemas;
};

#endif
