/***************************************************************************
                          kpgfunctionsfolder  -  description
                             -------------------
    begin                : Ne no 1 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kpgfunctionsfolder.h"

#include <kdebug.h>
#include <klocale.h>

#include "kpgconnection.h"
#include "kpgserver.h"
#include "kpgschema.h"
#include "kpgfunction.h"


KPGFunctionsFolder::KPGFunctionsFolder(KPGSchema *parent, pqxx::oid oidNameSpace)
	: KPGItemsFolder(parent, i18n("Functions"), m_pIconFolderRedClosed, m_pIconFolderRedOpen)
{
	m_oidNameSpace = oidNameSpace;
}


KPGFunctionsFolder::~KPGFunctionsFolder()
{
}

void KPGFunctionsFolder::refresh() throw(const KPGSqlException &)
{
    // delete all child items
  	while (QListViewItem * pItem = firstChild())
    	delete pItem;

	// Get pointer to server for version info       schema ->database->server 
	KPGServer *pServer = static_cast <KPGServer *> (parent()->parent()->parent());

	// obtain list of functions
	QString strQuery("SELECT pr.oid, pr.proname, description, pr.proisagg, pr.prosecdef, pr.proisstrict, proretset, pr.provolatile, pr.pronargs, pr.probin, pr.proacl, prorettype, \
typ.typname, lanname, pg_catalog.pg_get_userbyid(proowner) as funcowner, pr.proargtypes, pg_catalog.oidvectortypes(pr.proargtypes) AS arguments, pr.prosrc");
  
  	if(((pServer->versionMajor() == 8) && (pServer->versionMiddle() >= 1)) || (pServer->versionMajor() > 8))
    {
  		strQuery.append(", pr.proallargtypes, pr.proargmodes, pr.proargnames ");
  	}
  	else
  		strQuery.append(" ");
  	
	strQuery.append("FROM pg_catalog.pg_proc pr ");
	strQuery.append("JOIN pg_catalog.pg_type typ ON typ.oid=prorettype ");
	strQuery.append("JOIN pg_catalog.pg_language LNG ON LNG.oid=prolang ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_description des ON des.objoid=pr.oid ");
	strQuery.append("WHERE pronamespace = " + QString("%1").arg(m_oidNameSpace) + " ");
	strQuery.append("ORDER BY proname");
			
	try
	{
	  	KPGConnection *pConnection = connection();
	 	m_pqxxResultFunctions = pConnection->runQuery(strQuery);

		KPGFunction *pFunction = 0;
		
		for (result::size_type i = 0; i != m_pqxxResultFunctions.size(); ++i)
		{
				pqxx::oid oid;
				m_pqxxResultFunctions[i][0].to(oid);
			
				if(pFunction == 0)
					pFunction = new KPGFunction(this, m_pqxxResultFunctions[i]["proname"].c_str(), oid);
				else
					pFunction = new KPGFunction(this, pFunction, m_pqxxResultFunctions[i]["proname"].c_str(), oid);
				
				pFunction->setProperties(m_pqxxResultFunctions[i], pConnection);
				
				pFunction->setArgTypes(m_pqxxResultFunctions[i]["arguments"].c_str());
				pFunction->setSourceCode(pConnection->toUnicode(m_pqxxResultFunctions[i]["prosrc"].c_str()));
					
				if(((pServer->versionMajor() == 8) && (pServer->versionMiddle() >= 1)) || (pServer->versionMajor() > 8))
    			{	
					pFunction->setListArguments(m_pqxxResultFunctions[i]["proargtypes"].c_str(),
					    m_pqxxResultFunctions[i]["proallargtypes"].c_str(),
						m_pqxxResultFunctions[i]["proargmodes"].c_str(),
						m_pqxxResultFunctions[i]["proargnames"].c_str());
				}
				else
				{
					pFunction->setListArguments(m_pqxxResultFunctions[i]["proargtypes"].c_str(),
						QString::null,
						QString::null,
						QString::null);
				}
		}
	}
	catch (const std::exception &e)
	{
		kdError() << k_funcinfo << e.what() << endl;
		throw KPGSqlException(e.what(), strQuery);
	} 
}

void KPGFunctionsFolder::fillListOfObjectOidsWithChildItems(KPGOidNameList & listOfObjectOids)
{
	KPGSchema *pSchema = static_cast <KPGSchema *> (parent());
	
	QListViewItem * pItem = firstChild();
    while(pItem)
    {
        KPGTreeItem *pTreeItem = static_cast <KPGTreeItem *> (pItem);
        
        if(pTreeItem->type() != nodeFunction)
        {
            kdError() << k_funcinfo << "Logic error !" << endl;
            return;
        }
        
        KPGFunction *pFunction = static_cast <KPGFunction *> (pItem);
        
        KPGOidName oidName(pFunction->oid(), 
			pFunction->text(0),
			pSchema->text(0),
			pFunction->type(), 
			pFunction->pixmap(0),
			pFunction->description(),
			pFunction->oidReturnType(),
			pFunction->returnTypName(),
			pFunction->argumentTypes(),
			pFunction->returnSet());
        
        if(pFunction->returnSet())
        {
            oidName.setOidUnderlyingType(pFunction->oidReturnType()); 
        }
        
        listOfObjectOids.append(oidName);
        
        pItem = pItem->nextSibling();
    }
}

