//
// C++ Implementation: kpgrule
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgrule.h"

// include files for KDE
#include <kdebug.h>
#include <klocale.h>


#include "kpgrulesfolder.h"
#include "kpgdatabase.h"


KPGRule::KPGRule(KPGRulesFolder *parent, const QString name, pqxx::oid _oid)
 : KPGObject(parent, name, _oid)
{
	setPixmap(0, *m_pIconRule);
}

KPGRule::KPGRule(KPGRulesFolder *parent, KPGRule *after, const QString name, pqxx::oid _oid)
 : KPGObject(parent, after, name, _oid)
{
	setPixmap(0, *m_pIconRule);
}

KPGRule::~KPGRule()
{
}

// Refresh only constraint info, without childs objects
void KPGRule::refreshItem() throw(const KPGSqlException &)
{
	// Get pointer to owner table and database
	KPGTable *pTable = static_cast <KPGTable *> (parent()->parent());
	//KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pTable->parent()->parent()->parent());
		
	QString strQuery("SELECT rw.oid, rulename, description, is_instead, ev_type, ev_qual, nspname ");
	strQuery.append("FROM pg_catalog.pg_rewrite rw ");
	strQuery.append("JOIN pg_catalog.pg_class cl ON cl.oid=rw.ev_class ");
	strQuery.append("JOIN pg_catalog.pg_namespace nsp ON nsp.oid=cl.relnamespace ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_description des ON des.objoid=rw.oid ");
	strQuery.append("WHERE ev_class = ");
	strQuery.append(QString("%1").arg(pTable->oid()));
	strQuery.append(" AND rw.oid=");
	strQuery.append(QString("%1").arg(m_oid));
	
	try
	{
		KPGConnection *pConnection = connection();
		pqxx::result pqxxResultRules = pConnection->runQuery(strQuery);

		if(pqxxResultRules.size() != 1)
		{
			kdError() << k_funcinfo "Expect one row in result !" <<  endl;
			return;
		}
		
		setProperties(pqxxResultRules[0], pConnection);
	}
	catch (const std::exception &e)
	{
		kdError() << k_funcinfo << e.what() << endl;
		throw KPGSqlException(e.what(), strQuery);
	} 
}

void KPGRule::setProperties(const pqxx::result::tuple &pqxxTuple,
							const KPGConnection *pConnection)
{
	m_strDescription = pConnection->toUnicode(pqxxTuple["description"].c_str());
	pqxxTuple["is_instead"].to(m_bIsInstead);
	m_strEvType = pqxxTuple["ev_type"].c_str();
	m_strEvQual = pqxxTuple["ev_qual"].c_str();
	m_strNameSpace = pqxxTuple["nspname"].c_str();
}

// Refresh definition
void KPGRule::refreshDefinition(KPGConnection *pConnection) throw(const KPGSqlException &)
{
	QString strQuery = QString("SELECT pg_catalog.pg_get_ruledef(%1) AS definition;").arg(m_oid);
	pqxx::result pqxxResultDefinition = connection()->runQuery(strQuery);
			
	if (pqxxResultDefinition.size() > 0)
	{ 
		setDefinition(pConnection->toUnicode(pqxxResultDefinition[0][0].c_str()));
	}
}
