//
// C++ Interface: kpgrule
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGRULE_H
#define KPGRULE_H

#include "kpgobject.h"

class KPGRulesFolder;

/**
  * Table rule
  *
  * @author Lumir Vanek
  */
class KPGRule : public KPGObject
{
public:
    KPGRule(KPGRulesFolder *, const QString, pqxx::oid);
	KPGRule(KPGRulesFolder *, KPGRule *, const QString, pqxx::oid);
    ~KPGRule();

	virtual eNodeType type() const { return nodeRule; }
	
	// Get SQL object type 
  	virtual const char * getObjectType() const { return "RULE"; }
	
	void setProperties(const pqxx::result::tuple &, const KPGConnection *pConnection);
	
	void setDefinition(const QString strDefinition) { m_strDefinition = strDefinition; }
		
	// Refresh item, ald also childs objects
	void refresh() throw(const KPGSqlException &) { return refreshItem(); }
	
	// Refresh only this item, not childs
	void refreshItem() throw(const KPGSqlException &);
	
	/*
	 * Functions for accessing properties
	 */
	const QString & nameSpace() const { return m_strNameSpace; }
	bool isInstead() const { return m_bIsInstead; }
	const QString & evType() const { return m_strEvType; }
	const QString & evQual() const { return m_strEvQual; }
	const QString & definition() const { return m_strDefinition; }
	 
	void refreshDefinition(KPGConnection *) throw(const KPGSqlException &);	
		
protected:

	/*
	 * Properties
	 */
	QString m_strNameSpace;
	bool m_bIsInstead;
	QString m_strEvType;
	QString m_strEvQual;
	QString m_strDefinition;
};

#endif
