//
// C++ Implementation: kpgrulesfolder
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgrulesfolder.h"

// include files for KDE
#include <kdebug.h>
#include <klocale.h>


#include "kpgconnection.h"
#include "kpgrule.h"


KPGRulesFolder::KPGRulesFolder(KPGTable *parent)
	: KPGTableItemsFolder(parent, i18n("Rules"), m_pIconFolderYellowClosed, m_pIconFolderYellowOpen)
{
}

KPGRulesFolder::KPGRulesFolder(KPGTable *parent, KPGTableItemsFolder *after)
	: KPGTableItemsFolder(parent, after, i18n("Rules"), m_pIconFolderYellowClosed, m_pIconFolderYellowOpen)
{
}

KPGRulesFolder::~KPGRulesFolder()
{
}

void KPGRulesFolder::refresh(pqxx::oid oidTable) throw(const KPGSqlException &)
{
	// delete all child items (databases)
	while (QListViewItem * pItem = firstChild())
		delete pItem;
	
	QString strQuery("SELECT rw.oid, rulename, description, is_instead, ev_type, ev_qual, nspname ");
	strQuery.append("FROM pg_catalog.pg_rewrite rw ");
	strQuery.append("JOIN pg_catalog.pg_class cl ON cl.oid=rw.ev_class ");
	strQuery.append("JOIN pg_catalog.pg_namespace nsp ON nsp.oid=cl.relnamespace ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_description des ON des.objoid=rw.oid ");
	strQuery.append("WHERE ev_class = ");
	strQuery.append(QString("%1").arg(oidTable));
	strQuery.append(" ORDER BY rulename");
			
	try
	{
		KPGConnection *pConnection = connection();
		m_pqxxResultRules = pConnection->runQuery(strQuery);
			
		KPGRule *pRule = 0;
			
		for (result::size_type i = 0; i != m_pqxxResultRules.size(); ++i)
		{
			pqxx::oid oid;
			m_pqxxResultRules[i][0].to(oid);
				
			if(pRule == 0)
				pRule = new KPGRule(this, m_pqxxResultRules[i]["rulename"].c_str(), oid);
			else
				pRule = new KPGRule(this, pRule, m_pqxxResultRules[i]["rulename"].c_str(), oid);
				
			pRule->setProperties(m_pqxxResultRules[i], pConnection);
					
			//-- Get definition
			pRule->refreshDefinition(pConnection);
		}
	}
	catch (const std::exception &e)
	{
		kdError() << k_funcinfo << e.what() << endl;
		throw KPGSqlException(e.what(), strQuery);
	} 
}
