//
// C++ Implementation: kpgtableconstraint
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgtableconstraint.h"

// include files for KDE
#include <kdebug.h>
#include <kmessagebox.h>
#include <klocale.h>

#include "kpgtableconstraintsfolder.h"
#include "kpgdatabase.h"

KPGTableConstraint::KPGTableConstraint(KPGTableConstraintsFolder *parent, const QString name, pqxx::oid _oid)
  : KPGObject(parent, name, _oid)
{
}

KPGTableConstraint::KPGTableConstraint(KPGTableConstraintsFolder *parent, KPGTableConstraint *after, const QString name, pqxx::oid _oid)
  : KPGObject(parent, after, name, _oid)
{
}

KPGTableConstraint::~KPGTableConstraint()
{
}

// Refresh only constraint info, without childs objects
void KPGTableConstraint::refreshItem() throw(const KPGSqlException &)
{
	// Get pointer to owner table and database
	KPGTable *pTable = static_cast <KPGTable *> (parent()->parent());
	//KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pTable->parent()->parent()->parent());
		
	QString strQuery("SELECT c.oid, conname, CASE contype WHEN 'p' THEN 'Primary Key' WHEN 'f' THEN 'Foreign Key' WHEN 'u' THEN 'Unique' WHEN 'c' THEN 'Check' END AS contypedesc, description, condeferrable, condeferred, nspname "); 
		
	strQuery.append("FROM pg_catalog.pg_constraint c ");
	
	strQuery.append("JOIN pg_catalog.pg_class cl ON cl.oid=conrelid ");
	strQuery.append("JOIN pg_catalog.pg_namespace nl ON nl.oid=relnamespace ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_description des ON des.objoid=c.oid ");
		
	strQuery.append("WHERE conrelid = ");
	strQuery.append(QString("%1").arg(pTable->oid()));
	strQuery.append(" AND c.oid=");
	strQuery.append(QString("%1").arg(m_oid));
	
	try
	{
		KPGConnection *pConnection = connection();
    	pqxx::result pqxxResultConstraints = pConnection->runQuery(strQuery);

		if(pqxxResultConstraints.size() != 1)
		{
			kdError() << k_funcinfo "Expect one row in result !" <<  endl;
			return;
		}
									
		setProperties(pqxxResultConstraints[0], pConnection);
		
	}
	catch (const std::exception &e)
	{
		kdError() << k_funcinfo << e.what() << endl;
		throw KPGSqlException(e.what(), strQuery);
	} 
}


void KPGTableConstraint::setProperties(const pqxx::result::tuple &pqxxTuple,
									   const KPGConnection *pConnection)
{
	m_strDescription = pConnection->toUnicode(pqxxTuple["description"].c_str());
	pqxxTuple["condeferrable"].to(m_bIsDeferrable);
	pqxxTuple["condeferred"].to(m_bIsDeferred);
	m_strNspName = pqxxTuple["nspname"].c_str();	
}
