//
// C++ Implementation: kpgtableconstraintsfolder
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgtableconstraintsfolder.h"

// include files for KDE
#include <kdebug.h>
#include <klocale.h>

#include "kpgconnection.h"
#include "kpgprimarykeyconstr.h"
#include "kpgforeignkeyconstr.h"
#include "kpgcheckconstr.h"
#include "kpguniqueconstr.h"


KPGTableConstraintsFolder::KPGTableConstraintsFolder(KPGTable *parent)
	: KPGTableItemsFolder(parent, i18n("Constraints"), m_pIconFolderGreenClosed, m_pIconFolderGreenOpen)
{
}

KPGTableConstraintsFolder::KPGTableConstraintsFolder(KPGTable *parent, KPGTableItemsFolder *after)
	: KPGTableItemsFolder(parent, after, i18n("Constraints"), m_pIconFolderGreenClosed, m_pIconFolderGreenOpen)
{
}

KPGTableConstraintsFolder::~KPGTableConstraintsFolder()
{
}

void KPGTableConstraintsFolder::refresh(pqxx::oid oidTable) throw(const KPGSqlException &)
{
	// delete all child items
	while (QListViewItem * pItem = firstChild())
		delete pItem;
	
	QString strQuery("SELECT c.oid, conname, CASE contype WHEN 'p' THEN 'Primary Key' WHEN 'f' THEN 'Foreign Key' WHEN 'u' THEN 'Unique' WHEN 'c' THEN 'Check' END AS contypedesc, description, condeferrable, condeferred, nspname "); 
		
	strQuery.append("FROM pg_catalog.pg_constraint c ");
	
	strQuery.append("JOIN pg_catalog.pg_class cl ON cl.oid=conrelid ");
	strQuery.append("JOIN pg_catalog.pg_namespace nl ON nl.oid=relnamespace ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_description des ON des.objoid=c.oid ");
		
	strQuery.append("WHERE conrelid = ");
	strQuery.append(QString("%1").arg(oidTable));
	strQuery.append(" ORDER BY conname;");
			
	try
	{
		KPGConnection *pConnection = connection();
		m_pqxxResultConstraints = pConnection->runQuery(strQuery);
			
		KPGTableConstraint * pTableConstraint = 0;
			
		for (result::size_type i = 0; i != m_pqxxResultConstraints.size(); ++i)
		{
			pqxx::oid oid;
			m_pqxxResultConstraints[i][0].to(oid);
				
			QString strType(m_pqxxResultConstraints[i]["contypedesc"].c_str());
							
				
			if(strType == "Primary Key")
			{
				if(pTableConstraint == 0)
					pTableConstraint = new KPGPrimaryKeyConstr(this, m_pqxxResultConstraints[i]["conname"].c_str(), oid);
				else
					pTableConstraint = new KPGPrimaryKeyConstr(this, pTableConstraint, m_pqxxResultConstraints[i]["conname"].c_str(), oid);
				}
				
				if(strType == "Foreign Key")
				{
					
					if(pTableConstraint == 0)
						pTableConstraint = new KPGForeignKeyConstr(this, m_pqxxResultConstraints[i]["conname"].c_str(), oid);
					else
						pTableConstraint = new KPGForeignKeyConstr(this, pTableConstraint, m_pqxxResultConstraints[i]["conname"].c_str(), oid);
					
					KPGForeignKeyConstr *pForeignKeyConstr = static_cast <KPGForeignKeyConstr *> (pTableConstraint);	
					
					//-- Get foreign key properties
					strQuery = QString("SELECT confupdtype, confdeltype, conkey, confkey, conrelid, confrelid, refcl.relname AS reftable FROM pg_catalog.pg_constraint c LEFT \
					OUTER JOIN pg_catalog.pg_class refcl ON refcl.oid=confrelid WHERE c.oid=%1;").arg(oid);
					pqxx::result pqxxResultFk = connection()->runQuery(strQuery);
							
					if(pqxxResultFk.size() == 1)
					{ 
						pqxx::oid oidReferencedTable;
						pqxxResultFk[0]["confrelid"].to(oidReferencedTable);
								
						pForeignKeyConstr->setUpdType(pqxxResultFk[0]["confupdtype"].c_str());
						pForeignKeyConstr->setDelType(pqxxResultFk[0]["confdeltype"].c_str());
						pForeignKeyConstr->setConstrKey(pqxxResultFk[0]["conkey"].c_str());	
						pForeignKeyConstr->setReferencedTable(oidReferencedTable, pqxxResultFk[0]["reftable"].c_str());
						pForeignKeyConstr->setForeignKey(pqxxResultFk[0]["confkey"].c_str());
					} 
				}
				
				if(strType == "Unique")
				{
					if(pTableConstraint == 0)
						pTableConstraint = new KPGUniqueConstr(this, m_pqxxResultConstraints[i]["conname"].c_str(), oid);
					else
						pTableConstraint = new KPGUniqueConstr(this, pTableConstraint, m_pqxxResultConstraints[i]["conname"].c_str(), oid);			
				}
				
				if(strType == "Check")
				{
					if(pTableConstraint == 0)
						pTableConstraint = new KPGCheckConstr(this, m_pqxxResultConstraints[i]["conname"].c_str(), oid);
					else
						pTableConstraint = new KPGCheckConstr(this, pTableConstraint, m_pqxxResultConstraints[i]["conname"].c_str(), oid);
					
					//-- Get check source
					QString strQuery(QString("SELECT consrc FROM pg_catalog.pg_constraint c WHERE c.oid=%1;").arg(oid));
					pqxx::result pqxxResultExpression = connection()->runQuery(strQuery);;
									
					if(pqxxResultExpression.size() == 1)
					{ 
						(static_cast <KPGCheckConstr *> (pTableConstraint))->setExpression(pqxxResultExpression[0][0].c_str());
					}    
				}
				
				pTableConstraint->setProperties(m_pqxxResultConstraints[i], pConnection);
			}
	}
	catch (const std::exception &e)
	{
		kdError() << k_funcinfo << e.what() << endl;
		throw KPGSqlException(e.what(), strQuery);
	} 
}



