//
// C++ Implementation: kpgtrigger
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgtrigger.h"

// include files for KDE
#include <kdebug.h>
#include <klocale.h>

#include "kpgdatabase.h"
#include "kpgtriggersfolder.h"


KPGTrigger::KPGTrigger(KPGTriggersFolder *parent, const QString name, pqxx::oid _oid)
 : KPGObject(parent, name, _oid)
{
	setPixmap(0, *m_pIconTrigger);
}

KPGTrigger::KPGTrigger(KPGTriggersFolder *parent, KPGTrigger *after, const QString name, pqxx::oid _oid)
 : KPGObject(parent, after, name, _oid)
{
	setPixmap(0, *m_pIconTrigger);
}

KPGTrigger::~KPGTrigger()
{
}

// Refresh only column info, without childs objects
void KPGTrigger::refreshItem() throw(const KPGSqlException &)
{
	// Get pointer to owner table and database
	KPGTable *pTable = static_cast <KPGTable *> (parent()->parent());
	//KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pTable->parent()->parent()->parent());
			
	QString strQuery("SELECT t.oid, t.tgname, des.description, t.tgenabled, t.tgdeferrable, t.tginitdeferred, tgnargs, tgargs, nspname, tgfoid,  pr.proname ");
				
	strQuery.append("FROM pg_catalog.pg_trigger t ");
	strQuery.append("JOIN pg_catalog.pg_class cl ON cl.oid=tgrelid ");
	strQuery.append("JOIN pg_catalog.pg_namespace na ON na.oid=relnamespace ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_description des ON des.objoid=t.oid ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_proc pr ON tgfoid=pr.oid ");
	strQuery.append("WHERE NOT tgisconstraint ");
	strQuery.append("AND tgrelid=");
	strQuery.append(QString("%1").arg(pTable->oid()));
	strQuery.append(" AND t.oid=");
	strQuery.append(QString("%1").arg(m_oid));
	
	try
	{
		KPGConnection *pConnection = connection();
		pqxx::result pqxxResultTriggers = pConnection->runQuery(strQuery);

		if(pqxxResultTriggers.size() != 1)
		{
			kdError() << k_funcinfo "Expect one row in result !" <<  endl;
			return;
		}
		
		setProperties(pqxxResultTriggers[0], pConnection);
		
	}
	catch (const std::exception &e)
	{
		kdError() << k_funcinfo << e.what() << endl;
		throw KPGSqlException(e.what(), strQuery);
	} 
}


void KPGTrigger::setProperties(const pqxx::result::tuple &pqxxTuple,
							   const KPGConnection *pConnection)
{
    m_strIsEnabled = pqxxTuple["tgenabled"].c_str();
	pqxxTuple["tgdeferrable"].to(m_bDeferrable);
	pqxxTuple["tginitdeferred"].to(m_bInitDeferred);
	pqxxTuple["tgnargs"].to(m_iNArgs);
	pqxxTuple["tgfoid"].to(m_oidProcedure);
			
	m_strDescription = pConnection->toUnicode(pqxxTuple["description"].c_str());
	m_strArgs = pqxxTuple["tgargs"].c_str();
	m_strNameSpace = pqxxTuple["nspname"].c_str();
	m_strProcName = pqxxTuple["proname"].c_str();
}


