//
// C++ Implementation: kpgtype
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgtype.h"

// include files for KDE
#include <kiconloader.h>
#include <kdebug.h>
#include <klocale.h>

#include "kpgdatabase.h"
#include "kpgtypesfolder.h"
#include "kpgtypeattribute.h"


KPGType::KPGType(KPGTypesFolder *parent, const QString name, pqxx::oid _oid)
  : KPGObject(parent, name, _oid)
{
  setPixmap(0, *m_pIconType);
}

KPGType::KPGType(KPGTypesFolder *parent, KPGType *after, const QString name, pqxx::oid _oid)
  : KPGObject(parent, after, name, _oid)
{
  setPixmap(0, *m_pIconType);
}

KPGType::~KPGType()
{
}

void KPGType::setProperties(const pqxx::result::tuple &pqxxTuple,
							const KPGConnection *pConnection)
{
	pqxxTuple["typlen"].to(m_iTypLen);
	pqxxTuple["typbyval"].to(m_bByVal);
	pqxxTuple["typisdefined"].to(m_bIsDefined);
	pqxxTuple["typelem"].to(m_oidTypElem);
	pqxxTuple["typinputoid"].to(m_oidInputFunc);
	pqxxTuple["typoutputoid"].to(m_oidOutputFunc);
	pqxxTuple["tableoid"].to(m_oidTable);
			
	m_strDescription = pConnection->toUnicode(pqxxTuple["description"].c_str());
	m_strKind = pqxxTuple["type"].c_str();
	m_strTypDelim = pqxxTuple["typdelim"].c_str();
	m_strTypAlign = pqxxTuple["align"].c_str();
	m_strTypStorage = pqxxTuple["typstorage"].c_str();
	m_strElement = pqxxTuple["element"].c_str();
	m_strInputFunc = pqxxTuple["typinput"].c_str();
	m_strOutputFunc = pqxxTuple["typoutput"].c_str();
	m_strTableName = pqxxTuple["tablename"].c_str();
	m_strOwner = pqxxTuple["owner"].c_str();
		
	//--- Set icon for type
	if(m_strKind == "composite")
	{
		if(m_oidTable == 0)
			setPixmap(0, *m_pIconTypeStandalone);
		else
		  setPixmap(0, *m_pIconTypeComposite);
	}
		
	if(m_strKind == "base")
	{
		setPixmap(0, *m_pIconTypeBase);
	}
}

void KPGType::refresh() throw(const KPGSqlException &)
{
	// delete all child items
	while (QListViewItem * pItem = firstChild())
		delete pItem;
	
	QString strQuery("SELECT attname, atttypid, t.typname, a.attlen, attnum, attndims, atttypmod, nspname, description ");
			
	strQuery.append("FROM pg_catalog.pg_attribute a ");
	strQuery.append("JOIN pg_catalog.pg_type t ON t.oid=atttypid ");
	strQuery.append("JOIN pg_catalog.pg_namespace nsp ON t.typnamespace=nsp.oid ");
	strQuery.append("JOIN pg_catalog.pg_class c ON a.attrelid=c.oid ");
	strQuery.append(" LEFT OUTER JOIN pg_catalog.pg_description des ON des.objoid=attrelid AND des.objsubid=attnum");
	strQuery.append(" WHERE c.reltype = ");
	strQuery.append(QString("%1").arg(m_oid));
	strQuery.append(" ORDER BY attnum");
			
	try
	{
		KPGConnection *pConnection = connection();
		m_pqxxResultAttributes = pConnection->runQuery(strQuery);
		
		KPGTypeAttribute *pTypeAttribute = 0;
			
		for (result::size_type i = 0; i != m_pqxxResultAttributes.size(); ++i)
		{
			if(pTypeAttribute == 0)
				pTypeAttribute = new KPGTypeAttribute(this, m_pqxxResultAttributes[i]["attname"].c_str());
			else
				pTypeAttribute = new KPGTypeAttribute(this, pTypeAttribute, m_pqxxResultAttributes[i]["attname"].c_str());
			
							
			pTypeAttribute->setProperties(m_pqxxResultAttributes[i], pConnection);
		}
	}
	catch (const std::exception &e)
	{
		kdError() << k_funcinfo << e.what() << endl;
		throw KPGSqlException(e.what(), strQuery);
	} 
}

// Refresh only type info
void KPGType::refreshItem() throw(const KPGSqlException &)
{
	// Get pointer to server for version info
  	//KPGDatabase *pDatabase = static_cast <KPGDatabase *> (parent()->parent()->parent());
    	
  	QString strQuery("SELECT t.oid, t.typname, description, CASE WHEN t.typtype = 'b' THEN 'base' WHEN t.typtype = 'c' THEN 'composite' WHEN t.typtype = 'p' THEN 'pseudo' ELSE 'other' END as type, t.typlen, t.typbyval, t.typisdefined, t.typdelim, CASE WHEN t.typalign = 'c' THEN 'char' WHEN t.typalign = 's' THEN 'short' WHEN t.typalign = 'i' THEN 'int' WHEN t.typalign = 'd' THEN 'double' ELSE 'other' END AS align, CASE WHEN t.typstorage = 'p' THEN 'PLAIN' WHEN t.typstorage = 'e' THEN 'EXTERNAL' WHEN t.typstorage = 'm' THEN 'MAIN' WHEN t.typstorage = 'x' THEN 'EXTENDED' END AS typstorage, t.typelem, e.typname as element, t.typinput::oid AS typinputoid, t.typinput, t.typoutput::oid AS typoutputoid, t.typoutput, ct.oid AS tableoid, ct.relname AS tablename, pg_get_userbyid(t.typowner) as owner ");
	strQuery.append("FROM pg_catalog.pg_type t ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_type e ON e.oid=t.typelem ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_class ct ON ct.oid=t.typrelid AND ct.relkind <> 'c' ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_description des ON des.objoid=t.oid ");
	strQuery.append("WHERE t.oid = " + QString("%1").arg(m_oid));
				
	try
	{
		KPGConnection *pConnection = connection();
		pqxx::result pqxxResultTypes = pConnection->runQuery(strQuery);

		if(pqxxResultTypes.size() != 1)
		{
			kdError() << k_funcinfo "Expect one row in result !" <<  endl;
			return;
		}
		
		setProperties(pqxxResultTypes[0], pConnection);
   
   	}
    catch (const std::exception &e)
	{
		kdError() << k_funcinfo << e.what() << endl;
		throw KPGSqlException(e.what(), strQuery);
	} 
  
    // Refresh attributes list
	refresh();
}

void KPGType::fillListAttributes(KPGListTableColumns &listColumns, bool bIncludeSystemColumns)
{
	if((m_strKind == "base") || (m_strKind == "pseudo"))
	{
	   kdError() << k_funcinfo << "Only composite type have arguments" << endl;
	   return;
	}
	
	QListViewItem * pItem = firstChild();
	while(pItem)
	{
		KPGTypeAttribute *pTypeAttribute = static_cast <KPGTypeAttribute *> (pItem);
		
		if(bIncludeSystemColumns || (pTypeAttribute->attNum() > 0))
		{
			listColumns.append(KPGTableColumnWizInfo(
					pTypeAttribute->text(0), 
					pTypeAttribute->typName(),
					pTypeAttribute->attNdims(),
					pTypeAttribute->attNum(),
					*pTypeAttribute->pixmap(0),
					pTypeAttribute->description()
					));
		}
		
		pItem = pItem->nextSibling();
	}
}
