/***************************************************************************
                          kpgviewsfolder  -  description
                             -------------------
    begin                : Ne no 1 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kpgviewsfolder.h"

#include <kdebug.h>
#include <klocale.h>

#include "kpgconnection.h"
#include "kpgschema.h"
#include "kpgview.h"

KPGViewsFolder::KPGViewsFolder(KPGSchema *parent, pqxx::oid oidNameSpace)
	: KPGItemsFolder(parent, i18n("Views"), m_pIconFolderGreenClosed, m_pIconFolderGreenOpen)
{
	m_oidNameSpace = oidNameSpace;
}


KPGViewsFolder::~KPGViewsFolder()
{
}

void KPGViewsFolder::refresh() throw(const KPGSqlException &)
{
    // delete all child items (databases)
    while (QListViewItem * pItem = firstChild())
        delete pItem;

	// obtain list of views
    QString strQuery("SELECT c.oid, c.relname, description, pg_get_userbyid(c.relowner) AS viewowner, c.relacl ");
	strQuery.append("FROM pg_catalog.pg_class c ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_description des ON (des.objoid=c.oid and des.objsubid=0) ");
	strQuery.append("WHERE ((c.relhasrules AND (EXISTS (SELECT r.rulename FROM pg_catalog.pg_rewrite r WHERE ((r.ev_class = c.oid) AND (bpchar(r.ev_type) = '1'::bpchar)) ))) OR \
(c.relkind = 'v'::char)) ");
	strQuery.append("AND relnamespace = " + QString("%1").arg(m_oidNameSpace) + " ");
	strQuery.append("ORDER BY relname");
		
  	try
	{
		KPGConnection *pConnection = connection();
		m_pqxxResultViews = pConnection->runQuery(strQuery);
	
		KPGView *pgView = 0;
			
		for (result::size_type i = 0; i != m_pqxxResultViews.size(); ++i)
		{
			pqxx::oid oid;
			m_pqxxResultViews[i][0].to(oid);
			
			if(pgView == 0)
				pgView = new KPGView(this, m_pqxxResultViews[i]["relname"].c_str(), oid);
			else
				pgView = new KPGView(this, pgView, m_pqxxResultViews[i]["relname"].c_str(), oid);
							
				pgView->setProperties(
					m_pqxxResultViews[i]["viewowner"].c_str(), 
					m_pqxxResultViews[i]["relacl"].c_str(),
					m_pqxxResultViews[i]["description"].c_str()
					);
					
				//-- Get definition
				pgView->refreshDefinition(pConnection);
		}
	}
	catch (const std::exception &e)
	{
		kdError() << k_funcinfo << e.what() << endl;
		throw KPGSqlException(e.what(), strQuery);
	} 
}

void KPGViewsFolder::fillListOfObjectOidsWithChildItems(KPGOidNameList & listOfObjectOids)
{
	KPGSchema *pSchema = static_cast <KPGSchema *> (parent());
	
	QListViewItem * pItem = firstChild();
    while(pItem)
    {
        KPGTreeItem *pTreeItem = static_cast <KPGTreeItem *> (pItem);
        
        if(pTreeItem->type() != nodeView)
        {
            kdError() << k_funcinfo << "Logic error !" << endl;
            return;
        }
        
        KPGView *pView = static_cast <KPGView *> (pItem);
        
        KPGOidName oidName(pView->oid(), 
						   pView->text(0), 
						   pSchema->text(0),
						   pView->type(),
						   pView->pixmap(0),
						   pView->description());
                        
        listOfObjectOids.append(oidName);
        
        pItem = pItem->nextSibling();
    }
}

