//
// C++ Implementation: kpgpropertypagechildview
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgpropertypagechildview.h"

#include <qlayout.h>

#include <kiconloader.h>
#include <kdebug.h>
#include <klocale.h>
#include <kmessagebox.h>

#include "../kpogreview.h"

// Database objects includes
#include "../DbObjects/kpgserver.h"
#include "../DbObjects/kpgdatabase.h"
#include "../DbObjects/kpgschema.h"
#include "../DbObjects/kpgview.h"
#include "../DbObjects/kpgtable.h"
#include "../DbObjects/kpgsequence.h"
#include "../DbObjects/kpgfunction.h"
#include "../DbObjects/kpgprimarykey.h"
#include "../DbObjects/kpgindex.h"
#include "../DbObjects/kpglanguage.h"
#include "../DbObjects/kpggroupsfolder.h"
#include "../DbObjects/kpgusersfolder.h"
#include "../DbObjects/kpgtablespacesfolder.h"
#include "../DbObjects/kpgtablesfolder.h"
#include "../DbObjects/kpgviewsfolder.h"
#include "../DbObjects/kpgsequencesfolder.h"
#include "../DbObjects/kpgfunctionsfolder.h"
#include "../DbObjects/kpgoperatorsfolder.h"
#include "../DbObjects/kpgoperatorclassesfolder.h"
#include "../DbObjects/kpgaggregatesfolder.h"
#include "../DbObjects/kpgtypesfolder.h"
#include "../DbObjects/kpglanguagesfolder.h"
#include "../DbObjects/kpgdomainsfolder.h"
#include "../DbObjects/kpgconversionsfolder.h"
#include "../DbObjects/kpgcastsfolder.h"
#include "../DbObjects/kpgoperator.h"
#include "../DbObjects/kpgoperatorclass.h"
#include "../DbObjects/kpgaggregate.h"
#include "../DbObjects/kpgtype.h"
#include "../DbObjects/kpgdomain.h"
#include "../DbObjects/kpgconversion.h"
#include "../DbObjects/kpgcast.h"
#include "../DbObjects/kpgtablecolumnsfolder.h"
#include "../DbObjects/kpgtableconstraintsfolder.h"
#include "../DbObjects/kpgtableindexesfolder.h"
#include "../DbObjects/kpgrulesfolder.h"
#include "../DbObjects/kpgtriggersfolder.h"
#include "../DbObjects/kpgdomainconstraint.h"
#include "../DbObjects/kpgdomainconstraintsfolder.h"
#include "../DbObjects/kpgtablecolumn.h"
#include "../DbObjects/kpgprimarykeyconstr.h"
#include "../DbObjects/kpgforeignkeyconstr.h"
#include "../DbObjects/kpguniqueconstr.h"
#include "../DbObjects/kpguser.h"
#include "../DbObjects/kpggroup.h"
#include "../DbObjects/kpgtablespace.h"
#include "../DbObjects/kpgcheckconstr.h"
#include "../DbObjects/kpgrule.h"
#include "../DbObjects/kpgtrigger.h"
#include "../DbObjects/kpgtypeattribute.h"

// Property pages includes
#include "kpgvoidproppage.h"
#include "kpgpropertypage.h"
#include "kpgserverproppage.h"
#include "kpgtablespaceproppage.h"
#include "kpgdatabaseproppage.h"
#include "kpgschemaproppage.h"
#include "kpgtableproppage.h"
#include "kpgviewproppage.h"
#include "kpgtablecolumnproppage.h"
#include "kpgprimarykeyconstrproppage.h"
#include "kpgforeignkeyconstrproppage.h"
#include "kpgcheckconstrproppage.h"
#include "kpguniqueconstrproppage.h"
#include "kpgprimarykeyproppage.h"
#include "kpgindexproppage.h"
#include "kpgruleproppage.h"
#include "kpgtriggerproppage.h"
#include "kpgfunctionproppage.h"
#include "kpgsequenceproppage.h"
#include "kpgoperatorproppage.h"
#include "kpgoperatorclassproppage.h"
#include "kpgaggregateproppage.h"
#include "kpguserproppage.h"
#include "kpggroupproppage.h"
#include "kpgtypeproppage.h"
#include "kpglanguageproppage.h"
#include "kpgdomainproppage.h"
#include "kpgconversionproppage.h"
#include "kpgcastproppage.h"
#include "kpgdomainconstrproppage.h"
#include "kpgtypeattributeproppage.h"
#include "kpgusersfolderproppage.h"
#include "kpggroupsfolderproppage.h"
#include "kpgtablesfolderproppage.h"
#include "kpgtablespacesfolderproppage.h"
#include "kpgviewsfolderproppage.h"
#include "kpgsequencesfolderproppage.h"
#include "kpgfunctionsfolderproppage.h"
#include "kpgoperatorsfolderproppage.h"
#include "kpgoperatorclassproppage.h"
#include "kpgoperatorclassesfolderproppage.h"
#include "kpgaggregatesfolderproppage.h"
#include "kpgtypesfolderproppage.h"
#include "kpgdomainsfolderproppage.h"
#include "kpglanguagesfolderproppage.h"
#include "kpgconversionsfolderproppage.h"
#include "kpgcastsfolderproppage.h"
#include "kpgtablecolumnsfolderproppage.h"
#include "kpgtableconstraintsfolderproppage.h"
#include "kpgtableindexesfolderproppage.h"
#include "kpgrulesfolderproppage.h"
#include "kpgtriggersfolderproppage.h"
#include "kpgdomainconstrfolderproppage.h"

#include "../kpgutil.h"

KPGPropertyPageChildView::KPGPropertyPageChildView(KPoGreView *pPoGreView,
	KXMLGUIFactory *pXmlGuiFactory)
 	:
 	KXMLGUIClient(pPoGreView), 
 	KMdiChildView(i18n("Properties"), pPoGreView, "KPGPropertyPageChildView"),
    m_pXmlGuiFactory(pXmlGuiFactory)
{
	m_pPoGreView = pPoGreView;
	
	m_pWidgetProperties = 0;
	m_pPropertyPage = 0;
	
	m_pLayout = new QHBoxLayout(this, 0, -1, "layout" );
	
	setIcon( SmallIcon("info") );
	
	// Setup GUI
    //setFactory(pXmlGuiFactory);
	setXMLFile("kpgproppage.rc", true);
	m_bIsAddedToGuiFactory = false;
	
	//-----------------------------------------------------------------
	// Common clipboard actions
	m_pActCopyCell = new KAction(i18n("&Copy cell"), "editcopy", 0, this, SLOT(slotCopyCell()), actionCollection(), "copy_cell");
	
	m_pActCopyRow = new KAction(i18n("Copy &row"), 0, 0, this, SLOT(slotCopyRow()), actionCollection(), "copy_row");
	
	m_pActCopyTableCsv = new KAction(i18n("Copy table to C&SV"), 0, 0, this, SLOT(slotCopyTableCsv()), actionCollection(), "copy_table_csv");
	
	m_pActCopyTableXml = new KAction(i18n("Copy table to &XML"), 0, 0, this, SLOT(slotCopyTableXml()), actionCollection(), "copy_table_xml");
}


KPGPropertyPageChildView::~KPGPropertyPageChildView()
{
	destroyPropertiesWidget();
	removeFromGuiFactory();
}

// Add yourself to GUI factory
void KPGPropertyPageChildView::addToGuiFactory()
{
	if(!m_bIsAddedToGuiFactory)
    {
        //setFactory(m_pXmlGuiFactory);
        m_pXmlGuiFactory->addClient(this);
    	m_bIsAddedToGuiFactory = true;
    	//kdDebug() << k_funcinfo << endl;
    }
}
    
// Remove yourself from GUI factory
void KPGPropertyPageChildView::removeFromGuiFactory()
{
    if(m_bIsAddedToGuiFactory)
    {
        //setFactory(m_pXmlGuiFactory);
        m_pXmlGuiFactory->removeClient(this);
        m_bIsAddedToGuiFactory = false;
        //kdDebug() << k_funcinfo << endl;
    }
}


// Add this GUI client to factory
void KPGPropertyPageChildView::slotActivated()
{
	addToGuiFactory();
}
	// Remove this GUI client from factory
void KPGPropertyPageChildView::slotDeactivated()
{
	removeFromGuiFactory();
}

void KPGPropertyPageChildView::slotCopyCell()
{
	KPGUtil::copyCell(m_pPropertyPage->tableResult());
}

void KPGPropertyPageChildView::slotCopyRow()
{
	KPGUtil::copyRow(m_pPropertyPage->tableResult());
}

void KPGPropertyPageChildView::slotCopyTableCsv()
{
	KPGUtil::copyTableCsv(m_pPropertyPage->tableResult());
}

void KPGPropertyPageChildView::slotCopyTableXml()
{
	KPGUtil::copyTableXml(m_pPropertyPage->tableResult());
}

// Display properties of underlying database object
void KPGPropertyPageChildView::displayProperties()
{
	if(m_pPropertyPage)
	{
		m_pPropertyPage->displayProperties();
	}
	else
	{
		kdError() << k_funcinfo << " - Property page not exists" << endl;
	}
}

// Destroy Properties widget
void KPGPropertyPageChildView::destroyPropertiesWidget()
{
	// Close old widget property page
	if(m_pWidgetProperties)
	{
		// disconnect all
		disconnect(m_pWidgetProperties, 0, 0, 0);
		m_pWidgetProperties->close(true);
		m_pWidgetProperties = 0;
	}
}

// Create Properties widget, with regards to selected type in tree
QWidget* KPGPropertyPageChildView::createPropertiesWidget(KPGTreeItem * pItem)
{
	destroyPropertiesWidget();
	
	if(pItem == 0)
		return 0;
		
	m_pWidgetProperties = 0;
    m_pPropertyPage = 0;
	
  	// create new property page
  	switch(pItem->type())
    {
		//******************************************************************************************
		//
		// Main objects
		//
		//******************************************************************************************
				
        case KPGTreeItem::nodeServer:
        {
			KPGServerPropPage *pPropPage = new KPGServerPropPage(this, static_cast <KPGServer *> (pItem));  
			m_pWidgetProperties = pPropPage;
			m_pPropertyPage = pPropPage;
		}	
			break;
		
		
        case KPGTreeItem::nodeDatabase:
		{
			KPGDatabasePropPage *pPropPage = new KPGDatabasePropPage(this, static_cast <KPGDatabase *> (pItem));
			m_pWidgetProperties = pPropPage;
			m_pPropertyPage = pPropPage;
          
          connect(pPropPage, SIGNAL(sigRunWizard(const QString &)), m_pPoGreView, SLOT( slotRunWizard(const QString &))); 
        }
          break;
        				
		case KPGTreeItem::nodeSchema:
        {
          	KPGSchemaPropPage *pPropPage = new KPGSchemaPropPage(this, static_cast <KPGSchema *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
          	          	
          	connect(pPropPage, SIGNAL(sigRunWizard(const QString &)), m_pPoGreView, SLOT( slotRunWizard(const QString &))); 
        }  
          	break;
				
		case KPGTreeItem::nodeFolderGroups:
		{
			KPGGroupsFolderPropPage *pPropPage = new KPGGroupsFolderPropPage(this, static_cast <KPGGroupsFolder *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
        }
          	break;
				
		case KPGTreeItem::nodeFolderUsers:
		{
			KPGUsersFolderPropPage *pPropPage = new KPGUsersFolderPropPage(this, static_cast <KPGUsersFolder *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;
					
		case KPGTreeItem::nodeFolderTablespaces:
		{
			KPGTablespacesFolderPropPage *pPropPage = new KPGTablespacesFolderPropPage(this, static_cast <KPGTablespacesFolder *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;
				
		case KPGTreeItem::nodeUser:
		{
			KPGUserPropPage *pPropPage = new KPGUserPropPage(this, static_cast <KPGUser *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;
					
		case KPGTreeItem::nodeGroup:
		{
			KPGGroupPropPage *pPropPage = new KPGGroupPropPage(this, static_cast <KPGGroup *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;
					
		case KPGTreeItem::nodeTablespace:
		{
			KPGTablespacePropPage *pPropPage = new KPGTablespacePropPage(this, static_cast <KPGTablespace *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
         	
			connect(pPropPage, SIGNAL(sigRunWizard(const QString &)), m_pPoGreView, SLOT( slotRunWizard(const QString &))); 
		}
			break;
									
		//******************************************************************************************
		//
		// Database objects folders
		//
		//******************************************************************************************
										
		case KPGTreeItem::nodeFolderTables:
        {
          	KPGTablesFolderPropPage *pPropPage = new KPGTablesFolderPropPage(this, static_cast <KPGTablesFolder *> (pItem));
          	m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
        }
          	break;
				
		case KPGTreeItem::nodeFolderViews:
		{
			KPGViewsFolderPropPage *pPropPage = new KPGViewsFolderPropPage(this, static_cast <KPGViewsFolder *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;
					
		case KPGTreeItem::nodeFolderSequences:
		{
			KPGSequencesFolderPropPage *pPropPage = new KPGSequencesFolderPropPage(this, static_cast <KPGSequencesFolder *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;
					
		case KPGTreeItem::nodeFolderFunctions:
		{
			KPGFunctionsFolderPropPage *pPropPage = new KPGFunctionsFolderPropPage(this, static_cast <KPGFunctionsFolder *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;
					
		case KPGTreeItem::nodeFolderOperators:
        {
        	KPGOperatorsFolderPropPage *pPropPage = new KPGOperatorsFolderPropPage(this, static_cast <KPGOperatorsFolder *> (pItem));
        	m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
        }
        	break;
					
		case KPGTreeItem::nodeFolderOperatorClasses:
		{
			KPGOperatorClassesFolderPropPage *pPropPage = new KPGOperatorClassesFolderPropPage(this, static_cast <KPGOperatorClassesFolder *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;
					
		case KPGTreeItem::nodeFolderAggregates:
		{
			KPGAggregatesFolderPropPage *pPropPage = new KPGAggregatesFolderPropPage(this, static_cast <KPGAggregatesFolder *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;
											
		case KPGTreeItem::nodeFolderTypes:
		{
			KPGTypesFolderPropPage *pPropPage = new KPGTypesFolderPropPage(this, static_cast <KPGTypesFolder *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;
					
		case KPGTreeItem::nodeFolderLanguages: 
		{
			KPGLanguagesFolderPropPage *pPropPage = new KPGLanguagesFolderPropPage(this, static_cast <KPGLanguagesFolder *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;
				
		case KPGTreeItem::nodeFolderDomains:
        {
        	KPGDomainsFolderPropPage *pPropPage = new KPGDomainsFolderPropPage(this, static_cast <KPGDomainsFolder *> (pItem));
        	m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
        }
          	break;
					
		case KPGTreeItem::nodeFolderConversions:
		{	KPGConversionsFolderPropPage *pPropPage = new KPGConversionsFolderPropPage(this, static_cast <KPGConversionsFolder *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}	
			break;
					
		case KPGTreeItem::nodeFolderCasts:
		{
			KPGCastsFolderPropPage *pPropPage = new KPGCastsFolderPropPage(this, static_cast <KPGCastsFolder *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;		
				
				
		//******************************************************************************************
		//
		// Database objects
		//
		//******************************************************************************************
				
		case KPGTreeItem::nodeTable:
		{
			KPGTablePropPage *pPropPage = new KPGTablePropPage(this, static_cast <KPGTable *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
			
			connect(pPropPage, SIGNAL(sigRunWizard(const QString &)), m_pPoGreView, SLOT( slotRunWizard(const QString &))); 
		}
			break;

        case KPGTreeItem::nodeView:
		{
			KPGViewPropPage *pPropPage = new KPGViewPropPage(this, static_cast <KPGView *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
			
			connect(m_pWidgetProperties, SIGNAL(sigRunWizard(const QString &)), m_pPoGreView, SLOT( slotRunWizard(const QString &))); 
		}
			break;
					
		case KPGTreeItem::nodeSequence:
		{
			KPGSequencePropPage *pPropPage = new KPGSequencePropPage(this, static_cast <KPGSequence *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
			
			connect(pPropPage, SIGNAL(sigRunWizard(const QString &)), m_pPoGreView, SLOT( slotRunWizard(const QString &))); 
        }
        	break;
				
		case KPGTreeItem::nodeFunction:
		{
			KPGFunctionPropPage *pPropPage = new KPGFunctionPropPage(this, static_cast <KPGFunction *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
			
			connect(pPropPage, SIGNAL(sigRunWizard(const QString &)), m_pPoGreView, SLOT( slotRunWizard(const QString &))); 
		}
			break;
					
		case KPGTreeItem::nodeOperator:
        {
        	KPGOperatorPropPage *pPropPage = new KPGOperatorPropPage(this, static_cast <KPGOperator *> (pItem));
        	m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
        } 	
          	break;
				
		case KPGTreeItem::nodeOperatorClass:
		{
			KPGOperatorClassPropPage *pPropPage = new KPGOperatorClassPropPage(this, static_cast <KPGOperatorClass *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;
					
		case KPGTreeItem::nodeAggregate:
		{
			KPGAggregatePropPage *pPropPage = new KPGAggregatePropPage(this, static_cast <KPGAggregate *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;
				
		case KPGTreeItem::nodeType:
		{
			KPGTypePropPage *pPropPage = new KPGTypePropPage(this, static_cast <KPGType *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
        }
          	break;
				
		case KPGTreeItem::nodeLanguage:
		{
			KPGLanguagePropPage *pPropPage = new KPGLanguagePropPage(this, static_cast <KPGLanguage *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
			
          	connect(pPropPage, SIGNAL(sigRunWizard(const QString &)), m_pPoGreView, SLOT( slotRunWizard(const QString &))); 
        }
          	break; 
				
		case KPGTreeItem::nodeDomain:
		{
			KPGDomainPropPage *pPropPage = new KPGDomainPropPage(this, static_cast <KPGDomain *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
        }
          	break; 
				
		case KPGTreeItem::nodeConversion:
		{
			KPGConversionPropPage *pPropPage = new KPGConversionPropPage(this, static_cast <KPGConversion *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
        }
          	break; 
				
		case KPGTreeItem::nodeCast:
		{
			KPGCastPropPage *pPropPage = new KPGCastPropPage(this, static_cast <KPGCast *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
       	}
          	break;			
					
		//******************************************************************************************
		//
		// Table objects folders
		//
		//******************************************************************************************
				
						
		case KPGTreeItem::nodeFolderTableColumns:
		{
			KPGTableColumnsFolderPropPage *pPropPage = new KPGTableColumnsFolderPropPage(this, static_cast <KPGTableColumnsFolder *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;
					
		case KPGTreeItem::nodeFolderTableConstraints:
		{
			KPGTableConstraintsFolderPropPage *pPropPage = new KPGTableConstraintsFolderPropPage(this, static_cast <KPGTableConstraintsFolder *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;
					
		case KPGTreeItem::nodeFolderTableIndexes:
		{
			KPGTableIndexesFolderPropPage *pPropPage = new KPGTableIndexesFolderPropPage(this, static_cast <KPGTableIndexesFolder *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;
					
		case KPGTreeItem::nodeFolderRules:
		{
			KPGRulesFolderPropPage *pPropPage = new KPGRulesFolderPropPage(this, static_cast <KPGRulesFolder *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;
					
		case KPGTreeItem::nodeFolderTriggers:
        {
			KPGTriggersFolderPropPage *pPropPage = new KPGTriggersFolderPropPage(this, static_cast <KPGTriggersFolder *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
        }
          break;
        
        // Domain objects folders
            
        case KPGTreeItem::nodeFolderDomainConstraints:
		{
			KPGDomainConstrFolderPropPage *pPropPage = new KPGDomainConstrFolderPropPage(this, static_cast <KPGDomainConstraintsFolder *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;
					
		//******************************************************************************************
		//
		// Table objects
		//
		//******************************************************************************************
									
		case KPGTreeItem::nodeTableColumn:
		{
			KPGTableColumnPropPage *pPropPage = new KPGTableColumnPropPage(this, static_cast <KPGTableColumn *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;
					
		case KPGTreeItem::nodePrimaryKeyConstr:
		{
			KPGPrimaryKeyConstrPropPage *pPropPage = new KPGPrimaryKeyConstrPropPage(this, static_cast <KPGPrimaryKeyConstr *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;
					
		case KPGTreeItem::nodeForeignKeyConstr:
		{
			KPGForeignKeyConstrPropPage *pPropPage = new KPGForeignKeyConstrPropPage(this, static_cast <KPGForeignKeyConstr *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;
					
		case KPGTreeItem::nodeUniqueConstr:
		{
			KPGUniqueConstrPropPage *pPropPage = new KPGUniqueConstrPropPage(this, static_cast <KPGUniqueConstr *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;
					
		case KPGTreeItem::nodeCheckConstr:
		{
			KPGCheckConstrPropPage *pPropPage = new KPGCheckConstrPropPage(this, static_cast <KPGCheckConstr *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;
					
		case KPGTreeItem::nodePrimaryKey:
		{
			KPGPrimaryKeyPropPage *pPropPage = new KPGPrimaryKeyPropPage( this, static_cast <KPGPrimaryKey *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;
					
		case KPGTreeItem::nodeIndex:
		{
			KPGIndexPropPage *pPropPage = new KPGIndexPropPage( this, static_cast <KPGIndex *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;
					
		case KPGTreeItem::nodeRule:
		{
			KPGRulePropPage *pPropPage = new KPGRulePropPage(this, static_cast <KPGRule *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;
					
		case KPGTreeItem::nodeTrigger:
		{
			KPGTriggerPropPage *pPropPage = new KPGTriggerPropPage(this, static_cast <KPGTrigger *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;
          
        // Domain object
        case KPGTreeItem::nodeDomainConstr:
		{
			KPGDomainConstrPropPage *pPropPage = new KPGDomainConstrPropPage(this, static_cast <KPGDomainConstraint *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;
			
		//******************************************************************************************
		//
		// Type attributes
		//
		//******************************************************************************************
									
		case KPGTreeItem::nodeTypeAttribute:
		{
			KPGTypeAttributePropPage *pPropPage = new KPGTypeAttributePropPage(this, static_cast <KPGTypeAttribute *> (pItem));
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;
					
		//******************************************************************************************
		//
		// Unselected or unknown
		//
		//******************************************************************************************
					

        case KPGTreeItem::nodeUnselected:
        	return 0;
          	break;
					
		default:
		{
			KPGVoidPropPage *pPropPage = new KPGVoidPropPage(this);
			m_pWidgetProperties = pPropPage;
         	m_pPropertyPage = pPropPage;
		}
			break;
      } 
  
  	if(m_pWidgetProperties == 0) kdError() << k_funcinfo << "m_pWidgetProperties == 0" << endl;
    if(m_pPropertyPage == 0) kdError() << k_funcinfo << "m_pPropertyPage == 0" << endl;
    
	if(m_pWidgetProperties)
	{ 
		m_pLayout->addWidget( m_pWidgetProperties );
		m_pWidgetProperties->show();
				
		connect(m_pWidgetProperties, SIGNAL(sigSearchObject(const pqxx::oid)), m_pPoGreView, SLOT( slotSearchObject(const pqxx::oid)));
		
		connect(m_pWidgetProperties, SIGNAL(sigTablePropContextMenuRequested(int, int, const QPoint &)), this, SLOT(slotTablePropContextMenuRequested(int, int, const QPoint &)));
	}

	return m_pWidgetProperties;
}

bool KPGPropertyPageChildView::requestClose()
{
	if(KMessageBox::questionYesNo(this, i18n("Really close property window ?")) == KMessageBox::Yes) 
	{
		return true;
	}
	return false;
}

void KPGPropertyPageChildView::slotTablePropContextMenuRequested(int, int, const QPoint & pos)
{
    QWidget * pContainer = factory()->container("popupPropertyTable", this);

	if ( ! pContainer )
	{
		kdError() << k_funcinfo << " Couldn't get a container widget for the given menu name (popupResultTable)" << endl;
		return;
	}

	if ( ! pContainer->inherits("KPopupMenu") )
	{
		kdError() << k_funcinfo << " Wrong container widget" << endl;
		return;
	}

	KPopupMenu * pMenu = static_cast <KPopupMenu*> (pContainer);
	pMenu->popup( pos );
}

void KPGPropertyPageChildView::virtual_hook(int id, void* data)
{ 
    KXMLGUIClient::virtual_hook(id, data); 
}
