//
// C++ Implementation: kpgtypeproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgtypeproppage.h"

#include <qiconset.h>
#include <qtable.h>  

// include files for KDE
#include <ktabwidget.h>
#include <kdebug.h>
#include <klocale.h>

#include "../DbObjects/kpgtype.h"
#include "../DbObjects/kpgtreeitem.h"
#include "../kpglinklabel.h"
#include "../kpgutil.h"
#include "../DbObjects/kpgconnection.h"


KPGTypePropPage::KPGTypePropPage(QWidget *parent, KPGType * pType)
 : KPGTypePropPageBase(parent, "KPGTypePropPage")
{
	m_pType = pType;
	m_pTabWidget->setTabIconSet(tabAttributes, QIconSet(*KPGTreeItem::m_pIconTypeBase)); 
	displayProperties();
}


KPGTypePropPage::~KPGTypePropPage()
{
}

void KPGTypePropPage::displayProperties()
{
	QHeader* pHeader = m_pTableProperties->horizontalHeader();

  	pHeader->setLabel(0, i18n("Name"));
	pHeader->setLabel(1, i18n("Value"));
	pHeader->setLabel(2, i18n("Description"));
	
	int iRow = 0;
  
	//--- OID
	m_pTableProperties->setText(iRow, 0, i18n("OID"));
  	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pType->oid()));
	m_pTableProperties->setText(iRow++, 2, i18n("PostgreSQL row identifier"));
		
	//--- Name
	m_pTableProperties->setText(iRow, 0, i18n("Name"));
  	m_pTableProperties->setText(iRow, 1, m_pType->text(0));
	m_pTableProperties->setText(iRow++, 2, i18n("Type name"));
	
	//--- Description
	m_pTableProperties->setText(iRow, 0, i18n("Description"));
  	m_pTableProperties->setText(iRow, 1, m_pType->description());
	m_pTableProperties->setText(iRow++, 2, i18n("Description of the type"));
	
	//--- Type Name
	m_pTableProperties->setText(iRow, 0, i18n("Kind"));
 	m_pTableProperties->setText(iRow, 1, m_pType->kind());
	m_pTableProperties->setText(iRow++, 2, i18n("Kind of this type"));
	
	//--- Type length
	m_pTableProperties->setText(iRow, 0, i18n("Type length"));
  	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pType->typLen()));
	m_pTableProperties->setText(iRow++, 2, i18n("For a fixed-size type, typlen is the number of bytes in the internal representation of the type. But for a variable-length type, typlen is negative. -1 indicates a \"varlena\" type (one that has a length word), -2 indicates a null-terminated C string."));
	
	//--- By Value
	m_pTableProperties->setText(iRow, 0, i18n("By value"));
  	m_pTableProperties->setPixmap(iRow, 1, (m_pType->byValue()) ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("Determines whether internal routines pass a value of this \
	type by value or by reference. It had better be false if typlen is not 1, 2, or 4 \
	(or 8 on machines where Date is 8 bytes). Variable-length types are always passed by \
	reference. Note that typbyval can be false even if the length would allow pass-by-value; \
	this is currently true for type float4, for example."));
	
	//--- Is Defined
	m_pTableProperties->setText(iRow, 0, i18n("Is Defined"));
  	m_pTableProperties->setPixmap(iRow, 1, (m_pType->isDefined()) ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("True if the type is defined, false if this is a placeholder entry for a not-yet-defined type. When typisdefined is false, nothing except the type name, namespace, and OID can be relied on."));
	
	//--- Array delimiter
	m_pTableProperties->setText(iRow, 0, i18n("Array delimiter"));
  	m_pTableProperties->setText(iRow, 1, m_pType->typDelim());
	m_pTableProperties->setText(iRow++, 2, i18n("Character that separates two values of this type when parsing array input. Note that the delimiter is associated with the array element data type, not the array data type."));
	
	//--- Align
	m_pTableProperties->setText(iRow, 0, i18n("Align"));
  	m_pTableProperties->setText(iRow, 1, m_pType->typAlign());
	m_pTableProperties->setText(iRow++, 2, i18n("Alignment required when storing a value of this type. It applies to storage on disk as well as most representations of the value inside PostgreSQL. When multiple values are stored consecutively, such as in the representation of a complete row on disk, padding is inserted before a datum of this type so that it begins on the specified boundary."));
	
	//--- Storage
	m_pTableProperties->setText(iRow, 0, i18n("Storage"));
  	m_pTableProperties->setText(iRow, 1, m_pType->typStorage());
	m_pTableProperties->setText(iRow++, 2, i18n("Storage tells for varlena types (those with typlen = -1) if the type is prepared for toasting and what the default strategy for attributes of this type should be."));
	
	//--- Element
	m_pTableProperties->setText(iRow, 0, i18n("Element"));
  	KPGLinkLabel *pLabel = new KPGLinkLabel( m_pTableProperties, "Element" );
	pLabel->setValues(m_pType->oidTypElem(), m_pType->element());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("Element type name"));
	
	//--- Input function
	m_pTableProperties->setText(iRow, 0, i18n("Input function"));
  	pLabel = new KPGLinkLabel( m_pTableProperties, "Input function" );
	pLabel->setValues(m_pType->oidInputFunc(), m_pType->inputFunc());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("Input conversion function"));
		
	//--- Output function
	m_pTableProperties->setText(iRow, 0, i18n("Output function"));
  	pLabel = new KPGLinkLabel( m_pTableProperties, "Output function" );
	pLabel->setValues(m_pType->oidOutputFunc(), m_pType->outputFunc());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("Output conversion function "));
		
	//--- Table OID
	m_pTableProperties->setText(iRow, 0, i18n("Corresponding object"));
  	pLabel = new KPGLinkLabel( m_pTableProperties, "Corresponding object" );
	pLabel->setValues(m_pType->oidTable(), m_pType->tableName());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("If this is a composite type, then this points to the the corresponding table, view or sequence."));
		
	//--- Owner
	m_pTableProperties->setText(iRow, 0, i18n("Owner"));
  	m_pTableProperties->setText(iRow, 1, m_pType->owner());
	m_pTableProperties->setText(iRow++, 2, i18n("Owner of the type"));
	
	for(int nCol = 0; nCol < 3; nCol++)
	{
		m_pTableProperties->adjustColumn(nCol);
	}
	
	//--- Attributes
	displayAttributes();
}

void KPGTypePropPage::displayAttributes()
{	
	if((m_pType->kind() == "base") || (m_pType->kind() == "pseudo"))
	{
	   // base and pseudo types don't have properties
	   m_pTabWidget->setTabEnabled(tabAttributes, false);
	   return;
	}
	else
	{
		m_pTabWidget->setTabEnabled(tabAttributes, true);
	}
	    
	QTextCodec * pTextCodec = m_pType->connection()->textCodec();
	
	KPGUtil::fillPropertiesTable(m_pType->resultAttributes(), m_pTableAttributes, pTextCodec);
}

void KPGTypePropPage::slotTablePropDblClicked(int iRow, int iCol, int /*iButton*/, const QPoint & /*ptMousePos*/)
{
    QWidget *w = m_pTableProperties->cellWidget(iRow, iCol);
	if(w == 0)
		return;
					
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}

// Consumes request for context menu for property table
void KPGTypePropPage::slotTablePropContextMenuRequested(int row, int col, const QPoint & pos)
{
	emit sigTablePropContextMenuRequested(row, col, pos);	
}

#include "kpgtypeproppage.moc"
