//
// C++ Implementation: kpgtypesfolderproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgtypesfolderproppage.h"

#include <qtable.h>

#include <klocale.h>

#include "../kpgutil.h"
#include "../DbObjects/kpgtypesfolder.h"
#include "../DbObjects/kpgconnection.h"


KPGTypesFolderPropPage::KPGTypesFolderPropPage(QWidget* parent, KPGTypesFolder * pTypesFolder)
	: KPGPropertyPage(parent, "KPGTypesFolderPropPage")
{
	m_pTypesFolder = pTypesFolder;
	displayProperties();
}


KPGTypesFolderPropPage::~KPGTypesFolderPropPage()
{
}

void KPGTypesFolderPropPage::displayProperties()
{
	setLabelText(i18n("Types &list:"));
	
	QHeader* pHeader = m_pTableItems->horizontalHeader();
	
	int nCol = 0;
	pHeader->setLabel(nCol++, i18n("Name"));
  	pHeader->setLabel(nCol++, i18n("Description"));
	pHeader->setLabel(nCol++, i18n("Type"));
  	pHeader->setLabel(nCol++, i18n("Type length"));
	pHeader->setLabel(nCol++, i18n("By value"));
	pHeader->setLabel(nCol++, i18n("Is defined"));
	pHeader->setLabel(nCol++, i18n("Array delimiter"));
	pHeader->setLabel(nCol++, i18n("Align"));
	pHeader->setLabel(nCol++, i18n("Storage"));
	pHeader->setLabel(nCol++, i18n("Element"));
	pHeader->setLabel(nCol++, i18n("Input function"));
	pHeader->setLabel(nCol++, i18n("Output function"));
	pHeader->setLabel(nCol++, i18n("Corresponding object"));
	pHeader->setLabel(nCol++, i18n("Owner"));
	
	QTextCodec * pTextCodec = m_pTypesFolder->connection()->textCodec();
	
	KPGUtil::fillPropertiesTable(m_pTypesFolder->resultTypes(), m_pTableItems, pTextCodec);
}

