//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatecompositetypewidget2.h"

// include files for Qt
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qpushbutton.h>

// include files for KDE
#include <kdebug.h>
#include <klocale.h>
#include <klineedit.h>
#include <kcombobox.h> 
#include <klistview.h>
#include <kmessagebox.h>

// application specific includes
#include "../DbObjects/kpgdatabase.h"
#include "../DbObjects/kpgschema.h"
#include "../DbObjects/kpgtypesfolder.h"
#include "../DbObjects/kpgtype.h"
#include "../kpgutil.h"

#define NUM_BASIC_TYPES 33


KPGCreateCompositeTypeWidget2::KPGCreateCompositeTypeWidget2(QWidget *parent, const char *name, KPGDatabase *pDatabase)
 : KPGCreateCompositeTypeWidget2Base(parent, name)
{
    m_pDatabase = pDatabase;
    
    // fill schemas to combobox
    KPGUtil::fillComboBoxWithDatabaseSchemas(pDatabase, m_pComboBoxSchema, true); // only user schemas
    
    // refresh types from selected schema  
    refreshListOfTypes();
    slotComboDataTypeActivated(m_pComboBoxDataType->currentText());
    
    m_pListViewAttributes->setAllColumnsShowFocus(true);
    m_pListViewAttributes->setSortColumn(-1);
}


KPGCreateCompositeTypeWidget2::~KPGCreateCompositeTypeWidget2()
{
}

void KPGCreateCompositeTypeWidget2::refreshListOfTypes()
{
  m_pComboBoxDataType->clear();
      
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnChar, "char(n)");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnChar, "varchar(n)");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnChar, "text");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnXml, "xml");
  
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "smallint");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "integer");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "bigint");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "decimal(p, s)");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "numeric(p, s)");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "real");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "double precision");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "money");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnUuid, "uuid");
  
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnBit, "bit(n)");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnBit, "bit varying(n)");
  
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnBool, "bool");
  
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnTime, "time [(p)]");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnTime, "time [(p)] with time zone");
  
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnDate, "date");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnDate, "timestamp [(p)]");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnDate, "timestamp [(p)] with time zone");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnDate, "interval [(p)]");
  
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnBin, "bytea");
  
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "point");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "line");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "lseg");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "polygon");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "box");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "path");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "circle");
  
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNet, "inet");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNet, "cidr");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNet, "macaddr");
  
  if(m_pComboBoxDataType->count() != NUM_BASIC_TYPES)
    kdDebug() << "KPGCreateCompositeTypeWidget2::refreshListOfTypes : NUM_BASIC_TYPES wrong number" << endl;
  
  fillUserDatatypes();
  
  m_pComboBoxDataType->setCurrentItem(0);
}

void KPGCreateCompositeTypeWidget2::fillUserDatatypes()
{
  KPGTreeItem *pItem = m_pDatabase->getChildByName(m_pComboBoxSchema->currentText());
  if(!pItem)
  {
    kdDebug() << "KPGCreateCompositeTypeWidget2::fillUserDatatypes: no item found: " << m_pComboBoxSchema->currentText() << endl;
    return;
  }
        
  KPGSchema *pSchema = static_cast <KPGSchema *> (pItem);
  KPGTypesFolder *pTypesFolder = pSchema->getTypesFolder();
  
  pTypesFolder->fillComboBoxWithChildItems(m_pComboBoxDataType, true);
  
  m_pComboBoxDataType->setCurrentItem(0);
  slotComboDataTypeActivated(m_pComboBoxDataType->currentText());
}

// Fired, when user change attribute name
void KPGCreateCompositeTypeWidget2::slotAttributeNameChanged(const QString& strText)
{
    m_pPushButtonAttributeAdd->setEnabled(! strText.isEmpty());
}

void KPGCreateCompositeTypeWidget2::slotAttributeSelectionChanged(QListViewItem *pItem)
{
    m_pPushButtonAttributeDel->setEnabled(pItem != 0);
    m_pPushButtonAttributeUp->setEnabled(pItem != 0);
    m_pPushButtonAttributeDown->setEnabled(pItem != 0);
}

void KPGCreateCompositeTypeWidget2::slotAttributeCurrentChanged(QListViewItem *pItem)
{
    m_pPushButtonAttributeDel->setEnabled(pItem != 0);
    m_pPushButtonAttributeUp->setEnabled(pItem != 0);
    m_pPushButtonAttributeDown->setEnabled(pItem != 0);
}

void KPGCreateCompositeTypeWidget2::slotSchemaActivated(int)
{
  refreshListOfTypes();
}

void KPGCreateCompositeTypeWidget2::slotComboDataTypeActivated(const QString &strText)
{
  // Enable/disable precision and scale spins
  m_pSpinBoxPrecision->setEnabled(false);
  m_pSpinBoxScale->setEnabled(false);
  
  if(strText.find("(n)") > 0)
  {
    m_pSpinBoxPrecision->setEnabled(true);
  }
  
  if(strText.find("(p, s)") > 0)
  {
    m_pSpinBoxPrecision->setEnabled(true);
    m_pSpinBoxScale->setEnabled(true);
  }
  
  if(strText.find("[(p)]") > 0)
  {
    m_pSpinBoxPrecision->setEnabled(true);
  }

  // Set help text for selected data type
  if((strText == "char(n)") || (strText == "varchar(n)"))
  { 
    m_pSpinBoxPrecision->setMinValue( 0 );
    m_pSpinBoxPrecision->setMaxValue( 999 );
    
    m_pSpinBoxPrecision->setValue( 10 );
    
    return;
  }    

  if((strText == "decimal(p, s)") || (strText == "numeric(p, s)"))
  { 
    m_pSpinBoxPrecision->setMinValue( 1 );
    m_pSpinBoxPrecision->setMaxValue( 999 );
    
    m_pSpinBoxScale->setMinValue( 0 );
    m_pSpinBoxScale->setMaxValue( 999 );
    
    m_pSpinBoxPrecision->setValue( 10 );
    
    return;
  }    

  if((strText == "bit(n)") || (strText == "bit varying(n)"))
  { 
    m_pSpinBoxPrecision->setMinValue( 0 );
    m_pSpinBoxPrecision->setMaxValue( 999 );
    
    m_pSpinBoxPrecision->setValue( 255 );
    
    return;
  }
    
  if((strText == "time [(p)]") || (strText == "time [(p)] with time zone"))
  { 
    m_pSpinBoxPrecision->setMinValue( 0 );
    m_pSpinBoxPrecision->setMaxValue( 13 );
    
    m_pSpinBoxPrecision->setValue( 13 );
    return;
  }
  
  if((strText == "timestamp [(p)]") || (strText == "timestamp [(p)] with time zone") || (strText == "interval [(p)]"))
  { 
    m_pSpinBoxPrecision->setMinValue( 0 );
    m_pSpinBoxPrecision->setMaxValue( 6 );
    
    m_pSpinBoxPrecision->setValue( 6 );

    return;
  }
}

void KPGCreateCompositeTypeWidget2::slotNumDimensionsChanged(int nDimensions)
{
    if(nDimensions > 0)
    {
      m_pLineEditArrayDimDef->setEnabled(true);
      QString strDimensionsDef;
      for(int i = 0; i < nDimensions; i++)
       strDimensionsDef.append("[]");
       
       m_pLineEditArrayDimDef->setText(strDimensionsDef);
    }
    else
    {
      m_pLineEditArrayDimDef->setEnabled(false);
      m_pLineEditArrayDimDef->setText("");
    }
}

void KPGCreateCompositeTypeWidget2::slotAttributeAdd()
{
  if(m_pComboBoxDataType->currentItem() < 0) return;
  
  QString strAttributeName(m_pLineEditAttributeName->text());
  QString strAttributeType(m_pComboBoxDataType->currentText());
  QString strNamespace(m_pComboBoxSchema->currentText());
  
  QString strDefinition;
  
  if((m_pComboBoxDataType->currentItem() <= NUM_BASIC_TYPES - 1) || (strNamespace == "public"))
    strDefinition = strAttributeType;
  else
    strDefinition = strNamespace + "." +  strAttributeType;
  
  if(strAttributeName.isEmpty())
  {
    kdDebug() << "KPGCreateCompositeTypeWidget2::slotAttributeAdd - attibute name is empty !" << endl;
    return;
  }
    
  // Avoid attribute name duplicity
  QListViewItem *pLastItem = 0;
  
  QListViewItem * pItem = m_pListViewAttributes->firstChild();
  while(pItem)
  {
    pLastItem = pItem;
    
    if(pItem->text(0) == strAttributeName)
    { 
      KMessageBox::sorry(this, i18n("Attribute name already exists !"));
      return;   
    } 
    
    pItem = pItem->nextSibling();
  }
  
  //----------------------------------------------------------- 
  int i;
  if((i = strDefinition.find("(n)")) > 0)
  {
    strDefinition = strDefinition.left(strDefinition.length() - 3); // strip (n)
        
    strDefinition.append(QString("(%1)").arg(m_pSpinBoxPrecision->value()));
  }
  
  if((i = strDefinition.find("(p, s)")) > 0)
  {
    strDefinition = strDefinition.left(strDefinition.length() - 6); // strip (p, s)
    
    strDefinition.append(QString("(%1, %2)").arg(m_pSpinBoxPrecision->value()).arg(m_pSpinBoxScale->value()));
  }
  
  if((i = strDefinition.find("[(p)]")) > 0)
  {
    QString strDefinitionPostfix(strDefinition.mid(i + 5, strDefinition.length() - i - 5));
    strDefinition = strDefinition.left(i); // strip (n)
    
    strDefinition.append(QString("(%1)").arg(m_pSpinBoxPrecision->value()));
    strDefinition.append(strDefinitionPostfix);
  }
  
  // Create item for new attribute
  QListViewItem *pNewItem;
  if(pLastItem == 0) 
    pNewItem = new QListViewItem(m_pListViewAttributes, strAttributeName, strDefinition);
  else
    pNewItem = new QListViewItem(m_pListViewAttributes, pLastItem, strAttributeName, strDefinition);
  
  pNewItem->setPixmap(0, * m_pComboBoxDataType->pixmap(m_pComboBoxDataType->currentItem()));
  
  emit sigEnableNextButton(true);
  m_pLineEditAttributeName->setFocus(); // prepare for new attribute
  m_pLineEditAttributeName->setText("");
}

void KPGCreateCompositeTypeWidget2::slotAttributeDelete()
{
  QListViewItem *pSelectedItem = m_pListViewAttributes->selectedItem();
  if(pSelectedItem)
  { 
    delete pSelectedItem;
  }
      
  if(!m_pListViewAttributes->firstChild())
    emit sigEnableNextButton(false);
}

// Move selected attribute Up
void KPGCreateCompositeTypeWidget2::slotAttributeUp()
{
    QListViewItem *pSelectedItem = m_pListViewAttributes->selectedItem();
    if(!pSelectedItem) return;
    
    QListViewItem *pPrevItem = pSelectedItem->itemAbove();
    if(!pPrevItem) return;
    
    pPrevItem = pPrevItem->itemAbove();
        
    m_pListViewAttributes->takeItem(pSelectedItem);
    
    QListViewItem *pNewItem;
     
    if(pPrevItem)
      pNewItem = new QListViewItem(m_pListViewAttributes, pPrevItem, pSelectedItem->text(0),  pSelectedItem->text(1));
    else
      pNewItem = new QListViewItem(m_pListViewAttributes, pSelectedItem->text(0),  pSelectedItem->text(1));
    
    pNewItem->setPixmap(0, * pSelectedItem->pixmap(0));
         
    delete pSelectedItem;
     
    m_pListViewAttributes->setCurrentItem(pNewItem);
    m_pListViewAttributes->setSelected(pNewItem, true);
}

// Move selected attribute Down
void KPGCreateCompositeTypeWidget2::slotAttributeDown()
{
    QListViewItem *pSelectedItem = m_pListViewAttributes->selectedItem();
    if(!pSelectedItem) return;
    
    QListViewItem *pAfterItem = pSelectedItem->itemBelow();
    if(!pAfterItem) return;
    
    m_pListViewAttributes->takeItem(pSelectedItem);
     
    QListViewItem *pNewItem = new QListViewItem(m_pListViewAttributes, pAfterItem, pSelectedItem->text(0), pSelectedItem->text(1));
    pNewItem->setPixmap(0, * pSelectedItem->pixmap(0));
         
    delete pSelectedItem;
     
    m_pListViewAttributes->setCurrentItem(pNewItem);
    m_pListViewAttributes->setSelected(pNewItem, true);
}

const QString KPGCreateCompositeTypeWidget2::getSQL() const
{
  QString strSQL(" AS (\n");
 
  QListViewItem * pItem = m_pListViewAttributes->firstChild();
  while(pItem)
  {
    strSQL.append(pItem->text(0));
    strSQL.append(" ");
    strSQL.append(pItem->text(1));
        
    pItem = pItem->nextSibling();
    
    if(pItem)
      strSQL.append(",\n");
  }
  
  strSQL.append(")");
     
  return strSQL;
}

#include "kpgcreatecompositetypewidget2.moc"
