//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatecompositetypewizard.h"

// include files for Qt
#include <qcheckbox.h>
#include <qframe.h> 
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlistview.h>

// include files for KDE
#include <kdebug.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <kcombobox.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "../DbObjects/kpgdatabase.h"
#include "kpgcreatetypewidget1.h"
#include "kpgcreatecompositetypewidget2.h"


KPGCreateCompositeTypeWizard::KPGCreateCompositeTypeWizard(QWidget *parent, const char *name, KPGDatabase *pDatabase, QPtrList<QListViewItem> & listOfSchemas)
 : KPG4StepsWizard(parent, name)
{
  KPGCreateTypeWidget1 *pCreateTypeWidget1 = new KPGCreateTypeWidget1(WizardPage1, "KPGCreateTypeWidget1", listOfSchemas);
  m_pPageWidget1 = pCreateTypeWidget1;
  WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
  connect(pCreateTypeWidget1, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
      
  KPGCreateCompositeTypeWidget2 *pCreateTypeWidget2 = new KPGCreateCompositeTypeWidget2(WizardPage2, "KPGCreateCompositeTypeWidget2", pDatabase);
  m_pPageWidget2 = pCreateTypeWidget2;
  WizardPage2Layout->addWidget(m_pPageWidget2, 0, 0);
  connect(pCreateTypeWidget2, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton2(bool)));
  
  // default schema in page 2 is the same as in page 1
  pCreateTypeWidget2->m_pComboBoxSchema->setCurrentText(pCreateTypeWidget1->m_pComboBoxSchema->currentText());
    
  languageChange();
}

KPGCreateCompositeTypeWizard::~KPGCreateCompositeTypeWizard()
{
}

void KPGCreateCompositeTypeWizard::languageChange()
{
    KPG4StepsWizard::languageChange();
    
    setCaption( i18n( "Create new Composite type" ) );
    
    setTitle( WizardPage1, i18n( "Step 1 - Type name" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Define attributes" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Review SQL statement" ) );
    setTitle( WizardPage4, i18n( "Step 4 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGCreateCompositeTypeWizard::showPage(QWidget *pPage)
{
  if(pPage == WizardPage2) // Step 2 - Definr attributes list
  {
    (static_cast <KPGCreateCompositeTypeWidget2 *> (m_pPageWidget2))->m_pLineEditAttributeName->setFocus(); 
  }
  
  if(pPage == WizardPage3) // Step 3 - Review SQL statement
  {
    // prepare SQL statement
    QString strSQL;
    strSQL.append((static_cast <KPGCreateTypeWidget1 *> (m_pPageWidget1))->getSQL());
    strSQL.append((static_cast <KPGCreateCompositeTypeWidget2 *> (m_pPageWidget2))->getSQL());
    
    strSQL.append(";\n");
        
    m_pTextEditSQL->setText(strSQL);
  }
  
  if(pPage == WizardPage4) // Step 4 - Check operation result
  {
    runQuery();
  }

  // call parent
  KPG4StepsWizard::showPage(pPage);
}

#include "kpgcreatecompositetypewizard.moc"
