//
// C++ Implementation: kpgcreategroupwidget1
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreategroupwidget1.h"

// include files for Qt
#include <qpushbutton.h>
#include <qlistbox.h>

// include files for KDE
#include <klineedit.h>
#include <kactionselector.h> 
#include <kmessagebox.h>
#include <kdebug.h>

// application specific includes
#include "../DbObjects/kpgtreeitem.h"
#include "../kpgsqldialog.h"
#include "../kpgutil.h"


KPGCreateGroupWidget1::KPGCreateGroupWidget1(QWidget *parent, const char *name)
 : KPGCreateGroupWidget1Base(parent, name)
{
	m_pLineEditGroupName->setFocus();
}


KPGCreateGroupWidget1::~KPGCreateGroupWidget1()
{
}

void KPGCreateGroupWidget1::slotLineEditGroupNameChanged(const QString &strUserName)
{
	emit sigEnableNextButton(strUserName.length() > 0);
}
		
// Return part of SQL statement for CREATE VIEW
const QString KPGCreateGroupWidget1::getSQL() const
{
	QString strSQL(KPGUtil::quotedName(m_pLineEditGroupName->text()));
	
	QString strWITH(" WITH\n");
	
	if(m_pLineEditSysId->text().length() > 0)
	{
		strWITH.append("SYSID " + m_pLineEditSysId->text() + "\n");
	}

	for(unsigned int i = 0; i < m_pActionSelectorUsers->selectedListBox()->count(); i++)
	{
		if(i > 0)
			strWITH.append(", ");
		else
			strWITH.append("USER ");
			
		strWITH.append(KPGUtil::quotedName(m_pActionSelectorUsers->selectedListBox()->item(i)->text()));
	}
	
	if(strWITH.length() > 7)
		strSQL.append(strWITH);
		
	return strSQL;
}


#include "kpgcreategroupwidget1.moc"
