//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatetypewidget1.h"

// include files for Qt
#include <qlistview.h>
#include <qptrlist.h>

// include files for KDE
#include <kcombobox.h>
#include <klineedit.h>

#include "../kpgutil.h"

KPGCreateTypeWidget1::KPGCreateTypeWidget1(QWidget *parent, const char *name, QPtrList<QListViewItem> & listOfSchemas)
 : KPGCreateTypeWidget1Base(parent, name)
{
  int iCurrentItem = -1;
  int i = 0;  
  for(QListViewItem *pSchema = listOfSchemas.first(); pSchema; pSchema = listOfSchemas.next())
    {
      m_pComboBoxSchema->insertItem(* pSchema->pixmap(0), pSchema->text(0));
      
      if(pSchema->text(0) == "public")
        iCurrentItem = i;
        
      ++i;
    }
    
  if(iCurrentItem >= 0)
    m_pComboBoxSchema->setCurrentItem(iCurrentItem);
    
  m_pLineEditTypeName->setFocus();
}

KPGCreateTypeWidget1::~KPGCreateTypeWidget1()
{
}

void KPGCreateTypeWidget1::slotTypeNameChanged(const QString& strText)
{
  emit sigEnableNextButton(! strText.isEmpty());
}

// Return part of SQL statement for CREATE TYPE
const QString KPGCreateTypeWidget1::getSQL() const
{
  QString strSql("CREATE TYPE ");
  
  strSql.append(KPGUtil::fullyQualifiedName(m_pComboBoxSchema->currentText(), m_pLineEditTypeName->text()));
    
  return strSql;
}

#include "kpgcreatetypewidget1.moc"
