config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then
    # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

DE_INSTALLED="$(ls /etc/X11/xinit | grep -e xinitrc.?* | sed "s/xinitrc\.//g" | sed 's/[ \t]*$/,/')"
DE_INSTALLED="$(echo $DE_INSTALLED | sed "s/.$//")" #remove last comma
sed -i "s/^sessions.*$/sessions\t${DE_INSTALLED}/" etc/slim.conf.new

config etc/slim.conf.new

cat << EOF > /etc/rc.d/rc.4.new
#! /bin/sh
#
# rc.4		This file is executed by init(8) when the system is being
#		initialized for run level 4 (XDM)
#
# Version:	@(#)/etc/rc.d/rc.4	2.00	02/17/93
#
# Author:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
# At least 47% rewritten by:  Patrick J. Volkerding <volkerdi@slackware.com>
#

# Tell the viewers what's going to happen...
echo "Starting up X11 session manager..."

# Ok, slim should starts now:
if [ -x /usr/bin/slim ]; then
  exec /usr/bin/slim
fi

# Try to use GNOME's gdm session manager.  This comes first because if
# gdm is on the machine then the user probably installed it and wants
# to use it by default:
if [ -x /usr/bin/gdm ]; then
  exec /usr/bin/gdm -nodaemon
fi

# Someone thought that gdm looked prettier in /usr/sbin,
# so look there, too:
if [ -x /usr/sbin/gdm ]; then
  exec /usr/sbin/gdm -nodaemon
fi

# Not there?  OK, try to use KDE's kdm session manager:
if [ -x /opt/kde/bin/kdm ]; then
  exec /opt/kde/bin/kdm -nodaemon
elif [ -x /usr/bin/kdm ]; then
  exec /usr/bin/kdm -nodaemon
fi

# If all you have is XDM, I guess it will have to do:
if [ -x /usr/bin/xdm ]; then
  exec /usr/bin/xdm -nodaemon
elif [ -x /usr/X11R6/bin/xdm ]; then
  exec /usr/X11R6/bin/xdm -nodaemon
fi

# error
echo
echo "Hey, you don't have SLIM, KDM, GDM, or XDM.  Can't use runlevel 4 without"
echo "one of those installed."
sleep 30

# All done.

EOF

config etc/rc.d/rc.4.new