
/****************************************************************************
 *
 * All portions copyright their respective authors.  All rights reserved.
 *
 * This file is part of IVMan (ivm).
 *
 * This file may be distributed under the terms of the Q Public License
 * as defined by Troll Tech AS of Norway and appearing in the file
 * LICENSE.QPL included in the packaging of this file.
 * 
 * See http://www.troll.no/qpl for QPL licensing information.
 *
 * $Id: common.h,v 1.15 2005/11/22 04:11:36 ro_han Exp $
 *****************************************************************************/

#ifndef _COMMON_H
#define _COMMON_H

#ifdef HAVE_CONFIG_H
# ifndef _CONFIG_H
#  define _CONFIG_H
#  include "../../config.h"
# endif
#else
#error "No config.h!"
#endif

#ifndef __GNUC__
#define __FUNCTION__   ""
#endif


#include "../debug.h"
#define DEBUG(fmt, arg...) debug(fmt, __FILE__, __LINE__, __FUNCTION__, ## arg)

#ifdef HAVE_LIBINTL_H
#include <libintl.h>
#define _(String) gettext (String)
#else
#define _(String) String
#endif

#define gettext_noop(String) String
#define N_(String) gettext_noop (String)

#include "IvmConfigBase.h"
#include "IvmConfigCommon.h"

IvmConfigBase *cfg_base;

gboolean isdaemon;

#include <libhal.h>
#include "../hal_compat.h"
LibHalContext *hal_ctx;

#include "../dbus_interface.h"

#endif
