/*****************************************************************

Copyright (c) 1996-2000 the kicker authors see  http://webcvs.kde.org/kdebase/kicker/AUTHORS and alexandre
svetoslavsky alexsvetos@altern.org.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/


#ifndef _MINIPAGER3D_H
#define _MINIPAGER3D_H


#include <qvaluelist.h>
#include <qbutton.h>
#include <qlayout.h>
#include <qintdict.h>
#include <qtimer.h>

#include <kpanelapplet.h>
#include <kwin.h>
#include <qxembed.h>

class KProcess;
class KWinModule;
class MiniPager3D;
class QLineEdit;

class MiniPager3DButton : public QButton
{
	Q_OBJECT

	public:
		MiniPager3DButton(int desk, MiniPager3D *parent=0, const char *name=0);

		void setOn( bool b ) { QButton::setOn( b ); }
		void rename();

	signals:
		void buttonSelected( int desk );
		void showMenu( const QPoint&, int );

	protected:
		void paintEvent(QPaintEvent *ev);
		void resizeEvent(QResizeEvent *ev);
		void mousePressEvent( QMouseEvent * );
		void dragEnterEvent( QDragEnterEvent* e );
		void dragLeaveEvent( QDragLeaveEvent* e );
		int deskNum;

		bool eventFilter( QObject *, QEvent * );

	private slots:
		void slotToggled(bool);
		void slotClicked();
		void slotDragSwitch();

	private:
		MiniPager3D* pager();
		QLineEdit* lineedit;
		QTimer dragSwitchTimer;
};

class MiniPager3D : public KPanelApplet
{
	Q_OBJECT

	public:
		MiniPager3D(const QString& configFile, Type t = Normal, int actions = 0,
				   QWidget *parent = 0, const char *name = 0);

		virtual ~MiniPager3D();

		int widthForHeight(int height) const;
		int heightForWidth(int width) const;

		KWin::WindowInfo* info( WId win );
		KWinModule* kwin() { return kwin_module; }

		enum Mode { LabelNumber = 14, LabelName, LabelNone };
		Mode mode() const { return m_mode; }
		bool desktopPreview() const { return bDesktopPreview; }
		bool transparent() const { return bTransparent; }

		Orientation orientation() const { return KPanelApplet::orientation(); }

		void emitRequestFocus(){ emit requestFocus(); }

	public slots:
		void slotSetDesktop(int desktop);
		void slotSetDesktopCount(int count);
		void slotButtonSelected(int desk );
		void slotActiveWindowChanged( WId win );
		void slotWindowAdded( WId );
		void slotWindowRemoved( WId );
		void slotWindowChanged( WId, unsigned int );
		void slotStackingOrderChanged();
		void slotShowMenu( const QPoint&, int );
		void slotDesktopNamesChanged();
		void slotRefresh();

	protected:
		void allocateButtons();
		void updateDesktopLayout(int,int,int);
		void paintEvent(QPaintEvent *ev);
		void resizeEvent(QResizeEvent*);
		void wheelEvent( QWheelEvent* e );
		void showKPager(bool toggleShow);
		
		/*3d warpper*/
		void setCurrentDesktop( int desk );

	protected slots:
		void showPager();
		void applicationRegistered(const QCString &appName);
		void aboutToShowContextMenu();
		void contextMenuActivated(int);
		
		/* 3d */
		void contextMenu3DActivated(int);
		void read3dPrefs(KConfig*);

	private:

		QValueList<MiniPager3DButton*>btnList;
		QGridLayout *layout;
		int curDesk;
		int rmbDesk;
		WId active;
		QIntDict<KWin::WindowInfo> windows;
		KWinModule* kwin_module;
		uint m_rows;
		Mode m_mode;
		bool bDesktopPreview;
		bool bTransparent;

		KProcess *m_pPagerProcess;
		int desktopLayoutOrientation;
		int desktopLayoutX;
		int desktopLayoutY;
		QPopupMenu* contextMenu;
		
		
		
		/* 3d specific */
		QString* modes; //store 3ddesk modes labels
		int _3dMode; //the 3d mode selected
		QPopupMenu* menu3d; //additionnal menu entry
		bool bUse3d; //use 3ddesktop or not
		bool bZoomOut; //3dd nozoom option
};

#endif

