/*
Copyright (C) 2009 Parallel Realities

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "headers.h"

#include "system/record.h"
#include "init.h"
#include "game.h"

extern Input input, menuInput;
extern Game game;
extern Control control;
extern Entity player;

void getInput(int gameType)
{
	int key, button;
	SDL_Event event;

	/* Loop through waiting messages and process them */

	while (SDL_PollEvent(&event))
	{
		key = button = -1;

		switch (event.type)
		{
			case SDL_QUIT:
				exit(0);
			break;

			case SDL_ACTIVEEVENT:
				if ((event.active.state & SDL_APPINPUTFOCUS) && event.active.gain == FALSE)
				{
					focusLost();
				}

				else if ((event.active.state & SDL_APPACTIVE) && event.active.gain == FALSE)
				{
					focusLost();
				}
			break;

			case SDL_KEYDOWN:
				key = event.key.keysym.sym;

				if (key == SDLK_ESCAPE || key == control.button[CONTROL_PAUSE])
				{
					pauseGame();
				}

				if (key == control.button[CONTROL_INVENTORY])
				{
					if (!(player.flags & HELPLESS))
					{
						pauseGameInventory();
					}
				}

				else if (key == control.button[CONTROL_LEFT])
				{
					input.left = TRUE;
				}

				else if (key == control.button[CONTROL_RIGHT])
				{
					input.right = TRUE;
				}

				else if (key == control.button[CONTROL_UP])
				{
					input.up = TRUE;
				}

				else if (key == control.button[CONTROL_DOWN])
				{
					input.down = TRUE;
				}

				else if (key == control.button[CONTROL_JUMP])
				{
					input.jump = TRUE;
				}

				else if (key == control.button[CONTROL_NEXT])
				{
					input.next = TRUE;
				}

				else if (key == control.button[CONTROL_PREVIOUS])
				{
					input.previous = TRUE;
				}

				else if (key == control.button[CONTROL_SAVE])
				{
					input.save = TRUE;
				}

				else if (key == control.button[CONTROL_LOAD])
				{
					input.load = TRUE;
				}

				else if (key == control.button[CONTROL_TOGGLE])
				{
					input.toggle = TRUE;
				}

				else if (key == control.button[CONTROL_ACTIVATE])
				{
					input.activate = TRUE;
				}

				else if (key == control.button[CONTROL_CUT])
				{
					input.cut = TRUE;
				}

				else if (key == control.button[CONTROL_ATTACK])
				{
					input.attack = TRUE;
				}

				else if (key == control.button[CONTROL_FLY])
				{
					input.fly = TRUE;
				}

				else if (key == control.button[CONTROL_SNAP])
				{
					input.snap = TRUE;
				}

				else if (key == control.button[CONTROL_BLOCK])
				{
					input.block = TRUE;
				}

				else if (key == control.button[CONTROL_INTERACT])
				{
					input.interact = TRUE;
					input.grabbing = TRUE;
				}

				else if (key == FULLSCREEN_KEY && game.gameType != RECORDING)
				{
					toggleFullScreen();
				}

				else if (key == SCREENSHOT_KEY && game.gameType != RECORDING)
				{
					takeSingleScreenshot();
				}

				if (key == SDLK_UP)
				{
					menuInput.up = TRUE;
				}

				else if (key == SDLK_DOWN)
				{
					menuInput.down = TRUE;
				}

				else if (key == SDLK_RIGHT)
				{
					menuInput.right = TRUE;
				}

				else if (key == SDLK_LEFT)
				{
					menuInput.left = TRUE;
				}

				else if (key == SDLK_RETURN)
				{
					menuInput.attack = TRUE;
				}
			break;

			case SDL_KEYUP:
				key = event.key.keysym.sym;

				if (key == control.button[CONTROL_LEFT])
				{
					input.left = FALSE;
				}

				else if (key == control.button[CONTROL_RIGHT])
				{
					input.right = FALSE;
				}

				else if (key == control.button[CONTROL_UP])
				{
					input.up = FALSE;
				}

				else if (key == control.button[CONTROL_DOWN])
				{
					input.down = FALSE;
				}

				else if (key == control.button[CONTROL_JUMP])
				{
					input.jump = FALSE;
				}

				else if (key == control.button[CONTROL_NEXT])
				{
					input.next = FALSE;
				}

				else if (key == control.button[CONTROL_PREVIOUS])
				{
					input.previous = FALSE;
				}

				else if (key == control.button[CONTROL_SAVE])
				{
					input.save = FALSE;
				}

				else if (key == control.button[CONTROL_LOAD])
				{
					input.load = FALSE;
				}

				else if (key == control.button[CONTROL_TOGGLE])
				{
					input.toggle = FALSE;
				}

				else if (key == control.button[CONTROL_ACTIVATE])
				{
					input.activate = FALSE;
				}

				else if (key == control.button[CONTROL_CUT])
				{
					input.cut = FALSE;
				}

				else if (key == control.button[CONTROL_ATTACK])
				{
					input.attack = FALSE;
				}

				else if (key == control.button[CONTROL_FLY])
				{
					input.fly = FALSE;
				}

				else if (key == control.button[CONTROL_SNAP])
				{
					input.snap = FALSE;
				}

				else if (key == control.button[CONTROL_BLOCK])
				{
					input.block = FALSE;
				}

				else if (key == control.button[CONTROL_INTERACT])
				{
					input.interact = FALSE;
					input.grabbing = FALSE;
				}

				if (key == SDLK_UP)
				{
					menuInput.up = FALSE;
				}

				else if (key == SDLK_DOWN)
				{
					menuInput.down = FALSE;
				}

				else if (key == SDLK_RIGHT)
				{
					menuInput.right = FALSE;
				}

				else if (key == SDLK_LEFT)
				{
					menuInput.left = FALSE;
				}

				else if (key == SDLK_RETURN)
				{
					menuInput.attack = FALSE;
				}
			break;

			case SDL_MOUSEBUTTONDOWN:
				switch(event.button.button)
				{
					case SDL_BUTTON_LEFT:
						input.add = TRUE;
					break;

					case SDL_BUTTON_RIGHT:
						input.remove = TRUE;
					break;

					default:
					break;
				}
			break;

			case SDL_MOUSEBUTTONUP:
				switch(event.button.button)
				{
					case SDL_BUTTON_LEFT:
						input.add = FALSE;
					break;

					case SDL_BUTTON_RIGHT:
						input.remove = FALSE;
					break;

					default:
					break;
				}
			break;

			case SDL_JOYBUTTONDOWN:
				key = event.jbutton.button;

				if (key == control.button[CONTROL_PAUSE])
				{
					pauseGame();
				}

				if (key == control.button[CONTROL_INVENTORY])
				{
					if (!(player.flags & HELPLESS))
					{
						pauseGameInventory();
					}
				}

				if (key == control.button[CONTROL_LEFT])
				{
					input.left = TRUE;
				}

				else if (key == control.button[CONTROL_RIGHT])
				{
					input.right = TRUE;
				}

				else if (key == control.button[CONTROL_UP])
				{
					input.up = TRUE;
				}

				else if (key == control.button[CONTROL_DOWN])
				{
					input.down = TRUE;
				}

				else if (key == control.button[CONTROL_JUMP])
				{
					input.jump = TRUE;
				}

				else if (key == control.button[CONTROL_NEXT])
				{
					input.next = TRUE;
				}

				else if (key == control.button[CONTROL_PREVIOUS])
				{
					input.previous = TRUE;
				}

				else if (key == control.button[CONTROL_TOGGLE])
				{
					input.toggle = TRUE;
				}

				else if (key == control.button[CONTROL_ACTIVATE])
				{
					input.activate = TRUE;
				}

				else if (key == control.button[CONTROL_ATTACK])
				{
					input.attack = TRUE;
				}

				else if (key == control.button[CONTROL_BLOCK])
				{
					input.block = TRUE;
				}

				else if (key == control.button[CONTROL_INTERACT])
				{
					input.interact = TRUE;
					input.grabbing = TRUE;
				}
			break;

			case SDL_JOYBUTTONUP:
				key = event.jbutton.button;

				if (key == control.button[CONTROL_LEFT])
				{
					input.left = FALSE;
				}

				else if (key == control.button[CONTROL_RIGHT])
				{
					input.right = FALSE;
				}

				else if (key == control.button[CONTROL_UP])
				{
					input.up = FALSE;
				}

				else if (key == control.button[CONTROL_DOWN])
				{
					input.down = FALSE;
				}

				else if (key == control.button[CONTROL_JUMP])
				{
					input.jump = FALSE;
				}

				else if (key == control.button[CONTROL_NEXT])
				{
					input.next = FALSE;
				}

				else if (key == control.button[CONTROL_PREVIOUS])
				{
					input.previous = FALSE;
				}

				else if (key == control.button[CONTROL_ACTIVATE])
				{
					input.activate = FALSE;
				}

				else if (key == control.button[CONTROL_ATTACK])
				{
					input.attack = FALSE;
				}

				else if (key == control.button[CONTROL_BLOCK])
				{
					input.block = FALSE;
				}

				else if (key == control.button[CONTROL_INTERACT])
				{
					input.interact = FALSE;
					input.grabbing = FALSE;
				}
			break;

			case SDL_JOYAXISMOTION:
				if (event.jaxis.axis == 0)
				{
					if (event.jaxis.value < -3200)
					{
						input.left = TRUE;
					}

					else if (event.jaxis.value > 3200)
					{
						input.right = TRUE;
					}

					else
					{
						input.left = FALSE;
						input.right = FALSE;
					}
				}

				if (event.jaxis.axis == 1)
				{
					if (event.jaxis.value < -3200)
					{
						input.up = TRUE;
					}

					else if (event.jaxis.value > 3200)
					{
						input.down = TRUE;
					}

					else
					{
						input.up = FALSE;
						input.down = FALSE;
					}
				}
			break;
		}
	}

	/* Get the mouse coordinates */

	SDL_GetMouseState(&input.mouseX, &input.mouseY);

	if (game.paused == FALSE)
	{
		switch (gameType)
		{
			case RECORDING:
				putBuffer(input);
			break;

			case REPLAYING:
				input = getBuffer();
			break;

			default:
			break;
		}
	}
}

void resetControls(int editor)
{
	control.button[CONTROL_LEFT] = -1;
	control.button[CONTROL_RIGHT] = -1;
	control.button[CONTROL_UP] = -1;
	control.button[CONTROL_DOWN] = -1;
	control.button[CONTROL_JUMP] = 1;
	control.button[CONTROL_ADD] = -1;
	control.button[CONTROL_NEXT] = -1;
	control.button[CONTROL_PREVIOUS] = -1;
	control.button[CONTROL_SAVE] = -1;
	control.button[CONTROL_LOAD] = -1;
	control.button[CONTROL_TOGGLE] = -1;
	control.button[CONTROL_ACTIVATE] = -1;
	control.button[CONTROL_CUT] = -1;
	control.button[CONTROL_ATTACK] = -1;
	control.button[CONTROL_FLY] = -1;
	control.button[CONTROL_SNAP] = -1;
	control.button[CONTROL_INTERACT] = -1;
	control.button[CONTROL_PAUSE] = -1;
	control.button[CONTROL_BLOCK] = -1;

	if (game.joystick != NULL && editor == FALSE)
	{
		control.button[CONTROL_LEFT] = -1;
		control.button[CONTROL_RIGHT] = -1;
		control.button[CONTROL_UP] = -1;
		control.button[CONTROL_DOWN] = -1;
		control.button[CONTROL_JUMP] = 1;
		control.button[CONTROL_ADD] = -1;
		control.button[CONTROL_NEXT] = 7;
		control.button[CONTROL_PREVIOUS] = 6;
		control.button[CONTROL_SAVE] = -1;
		control.button[CONTROL_LOAD] = -1;
		control.button[CONTROL_TOGGLE] = -1;
		control.button[CONTROL_ACTIVATE] = 0;
		control.button[CONTROL_CUT] = -1;
		control.button[CONTROL_ATTACK] = 2;
		control.button[CONTROL_FLY] = SDLK_f;
		control.button[CONTROL_SNAP] = -1;
		control.button[CONTROL_INTERACT] = 3;
		control.button[CONTROL_PAUSE] = 9;
		control.button[CONTROL_BLOCK] = -1;
	}

	else
	{
		control.button[CONTROL_LEFT] = SDLK_LEFT;
		control.button[CONTROL_RIGHT] = SDLK_RIGHT;
		control.button[CONTROL_UP] = SDLK_UP;
		control.button[CONTROL_DOWN] = SDLK_DOWN;
		control.button[CONTROL_JUMP] = SDLK_SPACE;
		control.button[CONTROL_ADD] = SDLK_LEFT;
		control.button[CONTROL_NEXT] = SDLK_PERIOD;
		control.button[CONTROL_PREVIOUS] = SDLK_COMMA;
		control.button[CONTROL_SAVE] = SDLK_s;
		control.button[CONTROL_LOAD] = SDLK_l;
		control.button[CONTROL_TOGGLE] = SDLK_e;
		control.button[CONTROL_ACTIVATE] = SDLK_a;
		control.button[CONTROL_CUT] = SDLK_x;
		control.button[CONTROL_ATTACK] = SDLK_LCTRL;
		control.button[CONTROL_INVENTORY] = SDLK_z;
		#if DEV == 1
			control.button[CONTROL_FLY] = SDLK_f;
		#endif
		control.button[CONTROL_SNAP] = SDLK_g;
		control.button[CONTROL_INTERACT] = SDLK_c;
		control.button[CONTROL_PAUSE] = SDLK_p;
		control.button[CONTROL_BLOCK] = SDLK_LALT;
	}
}

void flushInputs()
{
	SDL_Event event;

	while (SDL_PollEvent(&event)) {}
}

int getSingleInput()
{
	int key;
	SDL_Event event;

	key = -2;

	if (SDL_PollEvent(&event))
	{
		switch (event.type)
		{
			case SDL_QUIT:
				exit(0);
			break;

			case SDL_KEYDOWN:
				key = event.key.keysym.sym;
			break;

			case SDL_JOYBUTTONDOWN:
				key = event.jbutton.button;
			break;
		}
	}

	return (key == SDLK_ESCAPE || key == SCREENSHOT_KEY || key == FULLSCREEN_KEY) ? -1 : key;
}

void writeControlsToFile(FILE *fp)
{
	fprintf(fp, "CONTROLS\n");
	fprintf(fp, "LEFT %d\n", control.button[CONTROL_LEFT]);
	fprintf(fp, "RIGHT %d\n", control.button[CONTROL_RIGHT]);
	fprintf(fp, "UP %d\n", control.button[CONTROL_UP]);
	fprintf(fp, "DOWN %d\n", control.button[CONTROL_DOWN]);
	fprintf(fp, "JUMP %d\n", control.button[CONTROL_JUMP]);
	fprintf(fp, "ATTACK %d\n", control.button[CONTROL_ATTACK]);
	fprintf(fp, "BLOCK %d\n", control.button[CONTROL_BLOCK]);
	fprintf(fp, "INVENTORY %d\n", control.button[CONTROL_INVENTORY]);
	fprintf(fp, "PREVIOUS %d\n", control.button[CONTROL_PREVIOUS]);
	fprintf(fp, "NEXT %d\n", control.button[CONTROL_NEXT]);
	fprintf(fp, "ACTIVATE %d\n", control.button[CONTROL_ACTIVATE]);
	fprintf(fp, "INTERACT %d\n", control.button[CONTROL_INTERACT]);
	fprintf(fp, "PAUSE %d\n", control.button[CONTROL_PAUSE]);
}

void readControlsFromFile(char *buffer)
{
	char *line, *token, *savePtr;

	line = strtok_r(buffer, "\n", &savePtr);

	while (line != NULL)
	{
		token = strtok(line, " ");

		if (strcmpignorecase(token, "LEFT") == 0)
		{
			token = strtok(NULL, "\0");

			control.button[CONTROL_LEFT] = atoi(token);
		}

		else if (strcmpignorecase(token, "RIGHT") == 0)
		{
			token = strtok(NULL, "\0");

			control.button[CONTROL_RIGHT] = atoi(token);
		}

		else if (strcmpignorecase(token, "UP") == 0)
		{
			token = strtok(NULL, "\0");

			control.button[CONTROL_UP] = atoi(token);
		}

		else if (strcmpignorecase(token, "DOWN") == 0)
		{
			token = strtok(NULL, "\0");

			control.button[CONTROL_DOWN] = atoi(token);
		}

		else if (strcmpignorecase(token, "JUMP") == 0)
		{
			token = strtok(NULL, "\0");

			control.button[CONTROL_JUMP] = atoi(token);
		}

		else if (strcmpignorecase(token, "ATTACK") == 0)
		{
			token = strtok(NULL, "\0");

			control.button[CONTROL_ATTACK] = atoi(token);
		}

		else if (strcmpignorecase(token, "BLOCK") == 0)
		{
			token = strtok(NULL, "\0");

			control.button[CONTROL_BLOCK] = atoi(token);
		}

		else if (strcmpignorecase(token, "PREVIOUS") == 0)
		{
			token = strtok(NULL, "\0");

			control.button[CONTROL_PREVIOUS] = atoi(token);
		}

		else if (strcmpignorecase(token, "NEXT") == 0)
		{
			token = strtok(NULL, "\0");

			control.button[CONTROL_NEXT] = atoi(token);
		}

		else if (strcmpignorecase(token, "ACTIVATE") == 0)
		{
			token = strtok(NULL, "\0");

			control.button[CONTROL_ACTIVATE] = atoi(token);
		}

		else if (strcmpignorecase(token, "INTERACT") == 0)
		{
			token = strtok(NULL, "\0");

			control.button[CONTROL_INTERACT] = atoi(token);
		}

		else if (strcmpignorecase(token, "PAUSE") == 0)
		{
			token = strtok(NULL, "\0");

			control.button[CONTROL_PAUSE] = atoi(token);
		}

		else if (strcmpignorecase(token, "INVENTORY") == 0)
		{
			token = strtok(NULL, "\0");

			control.button[CONTROL_INVENTORY] = atoi(token);
		}

		else if (strcmpignorecase(token, "GAME_SETTINGS") == 0)
		{
			readGameSettingsFromFile(savePtr);
		}

		line = strtok_r(NULL, "\n", &savePtr);
	}
}
