/*
Copyright (C) 2009 Parallel Realities

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "../headers.h"

#include "../graphics/animation.h"
#include "../system/properties.h"

extern Target target[MAX_TARGETS];
extern Entity *self;

static Entity targetEntity;

void freeTargets()
{
	/* Clear the list */

	memset(target, 0, sizeof(Target) * MAX_TARGETS);
}

Target *addTarget(int x, int y, char *name)
{
	int i;

	targetEntity.inUse = TRUE;

	loadProperties("lift/lift_target", &targetEntity);

	targetEntity.draw = &drawLoopingAnimationToMap;

	for (i=0;i<MAX_TARGETS;i++)
	{
		if (strcmpignorecase(name, target[i].name) == 0)
		{
			printf("Duplicate target name %s\n", name);

			exit(1);
		}
	}

	/* Loop through all the targets and find a free slot */

	for (i=0;i<MAX_TARGETS;i++)
	{
		if (target[i].active == FALSE)
		{
			memset(&target[i], 0, sizeof(Target));

			target[i].active = TRUE;

			target[i].x = x;
			target[i].y = y;

			STRNCPY(target[i].name, name, sizeof(target[i].name));

			return &target[i];
		}
	}

	printf("No free slots to add a target\n");

	exit(1);
}

void drawTargets()
{
	int i;

	self = &targetEntity;

	for (i=0;i<MAX_TARGETS;i++)
	{
		if (target[i].active == TRUE)
		{
			self->x = target[i].x;
			self->y = target[i].y;

			self->draw();
		}
	}
}

Target *getTargetByName(char *name)
{
	int i;

	for (i=0;i<MAX_TARGETS;i++)
	{
		if (target[i].active == TRUE && strcmpignorecase(target[i].name, name) == 0)
		{
			return &target[i];
		}
	}

	return NULL;
}

void writeTargetsToFile(FILE *fp)
{
	int i;

	for (i=0;i<MAX_TARGETS;i++)
	{
		if (target[i].active == TRUE)
		{
			fprintf(fp, "{\n");
			fprintf(fp, "TYPE TARGET\n");
			fprintf(fp, "NAME %s\n", target[i].name);
			fprintf(fp, "START_X %d\n", target[i].x);
			fprintf(fp, "START_Y %d\n", target[i].y);
			fprintf(fp, "}\n\n");
		}
	}
}
