/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import com.ctc.wstx.dtd.DTDAttribute;
import com.ctc.wstx.dtd.DTDElement;
import com.ctc.wstx.dtd.DTDSubset;
import com.ctc.wstx.dtd.ElementIdMap;
import com.ctc.wstx.dtd.NameKey;
import com.ctc.wstx.exc.WstxValidationException;
import com.ctc.wstx.sr.InputElementStack;
import com.ctc.wstx.sr.NsDefaultProvider;
import com.ctc.wstx.util.DataUtil;
import com.ctc.wstx.util.ExceptionUtil;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.Location;
import org.codehaus.stax2.validation.ValidationContext;
import org.codehaus.stax2.validation.XMLValidationException;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidator;

public abstract class DTDValidatorBase
extends XMLValidator
implements NsDefaultProvider {
    static final int DEFAULT_STACK_SIZE = 16;
    static final int EXP_MAX_ATTRS = 16;
    protected static final HashMap EMPTY_MAP = new HashMap();
    final boolean mHasNsDefaults;
    final DTDSubset mSchema;
    final ValidationContext mContext;
    final Map mElemSpecs;
    final Map mGeneralEntities;
    protected boolean mNormAttrs;
    protected DTDElement mCurrElem = null;
    protected DTDElement[] mElems = null;
    protected int mElemCount = 0;
    protected HashMap mCurrAttrDefs = null;
    protected DTDAttribute[] mAttrSpecs = new DTDAttribute[16];
    protected int mAttrCount = 0;
    protected int mIdAttrIndex = -1;
    protected final transient NameKey mTmpKey = new NameKey(null, null);
    char[] mTmpAttrValueBuffer = null;

    public DTDValidatorBase(DTDSubset schema, ValidationContext ctxt, boolean hasNsDefaults, Map elemSpecs, Map genEntities) {
        this.mSchema = schema;
        this.mContext = ctxt;
        this.mHasNsDefaults = hasNsDefaults;
        this.mElemSpecs = elemSpecs == null || elemSpecs.size() == 0 ? Collections.EMPTY_MAP : elemSpecs;
        this.mGeneralEntities = genEntities;
        this.mNormAttrs = true;
        this.mElems = new DTDElement[16];
    }

    public void setAttrValueNormalization(boolean state) {
        this.mNormAttrs = state;
    }

    public abstract boolean reallyValidating();

    public final XMLValidationSchema getSchema() {
        return this.mSchema;
    }

    public abstract void validateElementStart(String var1, String var2, String var3) throws XMLValidationException;

    public abstract String validateAttribute(String var1, String var2, String var3, String var4) throws XMLValidationException;

    public abstract String validateAttribute(String var1, String var2, String var3, char[] var4, int var5, int var6) throws XMLValidationException;

    public abstract int validateElementAndAttributes() throws XMLValidationException;

    public abstract int validateElementEnd(String var1, String var2, String var3) throws XMLValidationException;

    public void validateText(String text, boolean lastTextSegment) throws XMLValidationException {
    }

    public void validateText(char[] cbuf, int textStart, int textEnd, boolean lastTextSegment) throws XMLValidationException {
    }

    public abstract void validationCompleted(boolean var1) throws XMLValidationException;

    public String getAttributeType(int index) {
        DTDAttribute attr = this.mAttrSpecs[index];
        return attr == null ? "CDATA" : attr.getValueTypeString();
    }

    public int getIdAttrIndex() {
        int ix = this.mIdAttrIndex;
        if (ix == -2) {
            DTDAttribute idAttr;
            ix = -1;
            if (this.mCurrElem != null && (idAttr = this.mCurrElem.getIdAttribute()) != null) {
                DTDAttribute[] attrs = this.mAttrSpecs;
                int len = attrs.length;
                for (int i = 0; i < len; ++i) {
                    if (attrs[i] != idAttr) continue;
                    ix = i;
                    break;
                }
            }
            this.mIdAttrIndex = ix;
        }
        return ix;
    }

    public int getNotationAttrIndex() {
        int len = this.mAttrCount;
        for (int i = 0; i < len; ++i) {
            if (!this.mAttrSpecs[i].typeIsNotation()) continue;
            return i;
        }
        return -1;
    }

    public boolean mayHaveNsDefaults(String elemPrefix, String elemLN) {
        DTDElement elem;
        this.mTmpKey.reset(elemPrefix, elemLN);
        this.mCurrElem = elem = (DTDElement)this.mElemSpecs.get(this.mTmpKey);
        return elem != null && elem.hasNsDefaults();
    }

    public void checkNsDefaults(InputElementStack nsStack) throws XMLValidationException {
        HashMap m = this.mCurrElem.getNsDefaults();
        if (m != null) {
            for (Map.Entry me : m.entrySet()) {
                String prefix = (String)me.getKey();
                if (nsStack.isPrefixLocallyDeclared(prefix)) continue;
                DTDAttribute attr = (DTDAttribute)me.getValue();
                String uri = attr.getDefaultValue(this.mContext);
                nsStack.addNsBinding(prefix, uri);
            }
        }
    }

    NameKey getElemName() {
        DTDElement elem = this.mElems[this.mElemCount - 1];
        return elem.getName();
    }

    Location getLocation() {
        return this.mContext.getValidationLocation();
    }

    protected abstract ElementIdMap getIdMap();

    Map getEntityMap() {
        return this.mGeneralEntities;
    }

    char[] getTempAttrValueBuffer(int neededLength) {
        if (this.mTmpAttrValueBuffer == null || this.mTmpAttrValueBuffer.length < neededLength) {
            int size = neededLength < 100 ? 100 : neededLength;
            this.mTmpAttrValueBuffer = new char[size];
        }
        return this.mTmpAttrValueBuffer;
    }

    public boolean hasNsDefaults() {
        return this.mHasNsDefaults;
    }

    void reportValidationProblem(String msg) throws XMLValidationException {
        this.doReportProblem(msg, null);
    }

    void reportValidationProblem(String msg, Location loc) throws XMLValidationException {
        this.doReportProblem(msg, loc);
    }

    void reportValidationProblem(String format, String arg) throws XMLValidationException {
        this.doReportProblem(MessageFormat.format(format, arg), null);
    }

    void reportValidationProblem(String format, String arg1, String arg2) throws XMLValidationException {
        this.doReportProblem(MessageFormat.format(format, arg1, arg2), null);
    }

    protected void doReportProblem(String msg, Location loc) throws XMLValidationException {
        if (loc == null) {
            loc = this.getLocation();
        }
        throw WstxValidationException.create(msg, loc, 2);
    }

    protected void doAddDefaultValue(DTDAttribute attr) throws XMLValidationException {
        int defIx;
        String def = attr.getDefaultValue(this.mContext);
        if (def == null) {
            ExceptionUtil.throwInternal("null default attribute value");
        }
        NameKey an = attr.getName();
        String prefix = an.getPrefix();
        String uri = "";
        if (prefix != null && prefix.length() > 0 && ((uri = this.mContext.getNamespaceURI(prefix)) == null || uri.length() == 0)) {
            this.reportValidationProblem("Unbound namespace prefix '" + prefix + "' for default attribute " + attr);
            uri = "";
        }
        if ((defIx = this.mContext.addDefaultAttribute(an.getLocalName(), uri, prefix, def)) >= 0) {
            while (defIx >= this.mAttrSpecs.length) {
                this.mAttrSpecs = (DTDAttribute[])DataUtil.growArrayBy50Pct(this.mAttrSpecs);
            }
            while (this.mAttrCount < defIx) {
                this.mAttrSpecs[this.mAttrCount++] = null;
            }
            this.mAttrSpecs[defIx] = attr;
            this.mAttrCount = defIx + 1;
        }
    }
}

