/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.plaf.FreeColLookAndFeel;
import net.sf.freecol.client.gui.sound.MusicLibrary;
import net.sf.freecol.client.gui.sound.SfxLibrary;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.io.FreeColDataFile;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.io.FreeColTcFile;
import net.sf.freecol.common.logging.DefaultHandler;
import net.sf.freecol.common.networking.NoRouteToServerException;
import net.sf.freecol.common.option.LanguageOption;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.server.FreeColServer;

public final class FreeCol {
    public static final String META_SERVER_ADDRESS = "meta.freecol.org";
    public static final int META_SERVER_PORT = 3540;
    public static final String CLIENT_THREAD = "FreeColClient:";
    public static final String SERVER_THREAD = "FreeColServer:";
    public static final String METASERVER_THREAD = "FreeColMetaServer:";
    private static final int DEFAULT_WINDOW_SPACE = 100;
    private static final Logger logger = Logger.getLogger(FreeCol.class.getName());
    private static final String FREECOL_VERSION = "0.8.4";
    private static String FREECOL_REVISION;
    private static final String MIN_JDK_VERSION = "1.5";
    private static final String FILE_SEP;
    private static final String DEFAULT_SPLASH_FILE = "splash.jpg";
    private static final String DEFAULT_TC = "freecol";
    private static boolean windowed;
    private static boolean sound;
    private static boolean javaCheck;
    private static boolean memoryCheck;
    private static boolean consoleLogging;
    private static Dimension windowSize;
    private static String dataFolder;
    private static FreeColClient freeColClient;
    private static boolean standAloneServer;
    private static boolean publicServer;
    private static boolean inDebugMode;
    private static int serverPort;
    private static String serverName;
    private static final int DEFAULT_PORT = 3541;
    private static File mainUserDirectory;
    private static File saveDirectory;
    private static File tcUserDirectory;
    private static String tc;
    private static File savegameFile;
    private static File clientOptionsFile;
    private static Level logLevel;
    private static boolean checkIntegrity;

    private FreeCol() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            Manifest manifest = new Manifest(FreeCol.class.getResourceAsStream("/META-INF/MANIFEST.MF"));
            Attributes attribs = manifest.getMainAttributes();
            String revision = attribs.getValue("Revision");
            FREECOL_REVISION = "0.8.4 (Revision: " + revision + ")";
        }
        catch (Exception e) {
            System.out.println("Unable to load Manifest.");
            FREECOL_REVISION = FREECOL_VERSION;
        }
        FreeCol.handleArgs(args);
        JWindow splash = null;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("--splash")) continue;
            String splashFile = DEFAULT_SPLASH_FILE;
            if (args[i].indexOf(61) > 0) {
                splashFile = args[i].substring(args[i].indexOf(61) + 1);
            }
            splash = FreeCol.displaySplash(splashFile);
            break;
        }
        FreeCol.createAndSetDirectories();
        FreeCol.initLogging();
        Locale.setDefault(FreeCol.getLocale());
        if (javaCheck && !FreeCol.checkJavaVersion()) {
            FreeCol.removeSplash(splash);
            System.err.println("Java version 1.5 or better is recommended in order to run FreeCol. Use --no-java-check to skip this check.");
            System.exit(1);
        }
        int minMemory = 128;
        if (memoryCheck && Runtime.getRuntime().maxMemory() < (long)(minMemory * 1000000)) {
            FreeCol.removeSplash(splash);
            System.out.println("You need to assign more memory to the JVM. Restart FreeCol with:");
            System.out.println("java -Xmx" + minMemory + "M -jar FreeCol.jar");
            System.exit(1);
        }
        if (!FreeCol.initializeResourceFolders()) {
            FreeCol.removeSplash(splash);
            System.exit(1);
        }
        if (standAloneServer) {
            logger.info("Starting stand-alone server.");
            try {
                FreeColServer freeColServer;
                if (savegameFile != null) {
                    FreeColSavegameFile fis = null;
                    try {
                        fis = new FreeColSavegameFile(savegameFile);
                        XMLStreamReader in = FreeColServer.createXMLStreamReader(fis);
                        in.nextTag();
                        boolean defaultSingleplayer = Boolean.valueOf(in.getAttributeValue(null, "singleplayer"));
                        String publicServerStr = in.getAttributeValue(null, "publicServer");
                        boolean defaultPublicServer = publicServerStr != null ? Boolean.valueOf(publicServerStr) : false;
                        in.close();
                        freeColServer = new FreeColServer(savegameFile, defaultPublicServer, defaultSingleplayer, serverPort, serverName);
                    }
                    catch (Exception e) {
                        FreeCol.removeSplash(splash);
                        System.out.println("Could not load savegame.");
                        System.exit(1);
                        return;
                    }
                    finally {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                }
                try {
                    freeColServer = new FreeColServer(publicServer, false, serverPort, serverName);
                }
                catch (NoRouteToServerException e) {
                    FreeCol.removeSplash(splash);
                    System.out.println(Messages.message("server.noRouteToServer", new String[0]));
                    System.exit(1);
                    return;
                }
                Runtime runtime = Runtime.getRuntime();
                runtime.addShutdownHook(new Thread(){

                    public void run() {
                        freeColServer.getController().shutdown();
                    }
                });
                if (checkIntegrity) {
                    System.exit(freeColServer.getIntegrity() ? 0 : 1);
                }
            }
            catch (IOException e) {
                FreeCol.removeSplash(splash);
                System.err.println("Error while loading server: " + e);
                System.exit(1);
            }
        } else {
            ImageLibrary lib;
            Rectangle bounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            if (FreeCol.windowSize.width == -1 || FreeCol.windowSize.height == -1) {
                FreeCol.windowSize.width = bounds.width - 100;
                FreeCol.windowSize.height = bounds.height - 100;
            }
            Dimension preloadSize = windowed ? windowSize : new Dimension(bounds.width, bounds.height);
            ResourceManager.preload(preloadSize);
            try {
                UIManager.setLookAndFeel(new FreeColLookAndFeel(dataFolder, preloadSize));
            }
            catch (UnsupportedLookAndFeelException e) {
                logger.warning("Could not load the \"FreeCol Look and Feel\"");
            }
            catch (FreeColException e) {
                FreeCol.removeSplash(splash);
                e.printStackTrace();
                System.out.println("\nThe data files could not be found by FreeCol. Please make sure");
                System.out.println("they are present. If FreeCol is looking in the wrong directory");
                System.out.println("then run the game with a command-line parameter:");
                System.out.println("");
                FreeCol.printUsage();
                System.exit(1);
            }
            logger.info("Now starting to load images.");
            try {
                lib = new ImageLibrary(dataFolder);
            }
            catch (FreeColException e) {
                FreeCol.removeSplash(splash);
                e.printStackTrace();
                System.out.println("\nThe data files could not be found by FreeCol. Please make sure");
                System.out.println("they are present. If FreeCol is looking in the wrong directory");
                System.out.println("then run the game with a command-line parameter:");
                System.out.println("");
                FreeCol.printUsage();
                System.exit(1);
                return;
            }
            MusicLibrary musicLibrary = null;
            SfxLibrary sfxLibrary = null;
            if (sound) {
                try {
                    musicLibrary = new MusicLibrary(dataFolder);
                }
                catch (FreeColException e) {
                    System.out.println("The music files could not be loaded by FreeCol. Disabling music.");
                }
                try {
                    sfxLibrary = new SfxLibrary(dataFolder);
                }
                catch (FreeColException e) {
                    System.out.println("The sfx files could not be loaded by FreeCol. Disabling sfx.");
                }
            }
            freeColClient = new FreeColClient(windowed, windowSize, lib, musicLibrary, sfxLibrary);
            if (savegameFile != null) {
                final FreeColClient theFreeColClient = freeColClient;
                final File theSavegameFile = savegameFile;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        theFreeColClient.getConnectController().loadGame(theSavegameFile);
                    }
                });
            }
        }
        FreeCol.removeSplash(splash);
    }

    private static JWindow displaySplash(String filename) {
        try {
            Image im = Toolkit.getDefaultToolkit().getImage(filename);
            JWindow f = new JWindow();
            f.getContentPane().add(new JLabel(new ImageIcon(im)));
            f.pack();
            Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
            f.setLocation(center.x - f.getWidth() / 2, center.y - f.getHeight() / 2);
            f.setVisible(true);
            return f;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while displaying splash screen", e);
            return null;
        }
    }

    private static void removeSplash(JWindow splash) {
        if (splash != null) {
            splash.setVisible(false);
            splash.dispose();
        }
    }

    private static void initLogging() {
        final Logger baseLogger = Logger.getLogger("");
        Handler[] handlers = baseLogger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            baseLogger.removeHandler(handlers[i]);
        }
        try {
            baseLogger.addHandler(new DefaultHandler(consoleLogging, mainUserDirectory));
            if (inDebugMode) {
                logLevel = Level.FINEST;
            }
            Logger freecolLogger = Logger.getLogger("net.sf.freecol");
            freecolLogger.setLevel(logLevel);
        }
        catch (FreeColException e) {
            e.printStackTrace();
        }
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread thread, Throwable e) {
                baseLogger.log(Level.WARNING, "Uncaught exception from thread: " + thread, e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Locale getLocale() {
        XMLInputFactory xif = XMLInputFactory.newInstance();
        XMLStreamReader in = null;
        try {
            in = xif.createXMLStreamReader(new BufferedReader(new FileReader(FreeCol.getClientOptionsFile())));
            in.nextTag();
            int eventid22 = in.getEventType();
            while (eventid22 != 8) {
                if (eventid22 == 1 && "model.option.languageOption".equals(in.getAttributeValue(null, "id"))) {
                    Locale locale = LanguageOption.getLocale(in.getAttributeValue(null, "value"));
                    return locale;
                }
                in.nextTag();
                eventid22 = in.getEventType();
            }
            logger.log(Level.WARNING, "Language setting not found in client options file.  Using default.");
            Locale eventid22 = Locale.getDefault();
            return eventid22;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while loading options.", e);
            Locale locale = Locale.getDefault();
            return locale;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception while closing stream.", e);
                return Locale.getDefault();
            }
        }
    }

    public static int getDefaultPort() {
        return 3541;
    }

    public static File getClientOptionsFile() {
        return clientOptionsFile;
    }

    public static Specification getSpecification() {
        return Specification.getSpecification();
    }

    public static FreeColClient getFreeColClient() {
        return freeColClient;
    }

    private static File createAndSetDirectories() {
        String freeColDirectoryName;
        String string = freeColDirectoryName = "/".equals(System.getProperty("file.separator")) ? ".freecol" : DEFAULT_TC;
        if (mainUserDirectory == null) {
            mainUserDirectory = new File(System.getProperty("user.home"), freeColDirectoryName);
        }
        if (mainUserDirectory.exists()) {
            if (mainUserDirectory.isFile()) {
                System.out.println("Could not create " + freeColDirectoryName + " under " + System.getProperty("user.home") + " because there " + "already exists a regular file with the same name.");
                return null;
            }
        } else {
            mainUserDirectory.mkdir();
        }
        if (saveDirectory == null) {
            saveDirectory = new File(mainUserDirectory, "save");
        }
        if (saveDirectory.exists()) {
            if (saveDirectory.isFile()) {
                System.out.println("Could not create freecol/save under " + System.getProperty("user.home") + " because there " + "already exists a regular file with the same name.");
                return null;
            }
        } else {
            saveDirectory.mkdir();
        }
        if ((tcUserDirectory = new File(mainUserDirectory, tc)).exists()) {
            if (tcUserDirectory.isFile()) {
                System.out.println("Could not create freecol/" + tc + " under " + System.getProperty("user.home") + " because there " + "already exists a regular file with the same name.");
                return null;
            }
        } else {
            tcUserDirectory.mkdir();
        }
        clientOptionsFile = new File(tcUserDirectory, "options.xml");
        return mainUserDirectory;
    }

    private static void setSavegame(String name) {
        savegameFile = new File(name);
        if (!savegameFile.exists() || !savegameFile.isFile()) {
            savegameFile = new File(FreeCol.getSaveDirectory(), name);
            if (!savegameFile.exists() || !savegameFile.isFile()) {
                System.out.println("Could not find savegame file: " + name);
                System.exit(1);
            }
        } else {
            FreeCol.setSaveDirectory(savegameFile.getParentFile());
        }
    }

    public static File getSaveDirectory() {
        return saveDirectory;
    }

    public static void setSaveDirectory(File saveDirectory) {
        FreeCol.saveDirectory = saveDirectory;
    }

    public static File getDataDirectory() {
        if (dataFolder.equals("")) {
            return new File("data");
        }
        return new File(dataFolder);
    }

    public static File getModsDirectory() {
        return new File(FreeCol.getDataDirectory(), "mods");
    }

    public static File getAutosaveDirectory() {
        return saveDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean initializeResourceFolders() {
        FreeColTcFile tcData;
        try {
            FreeColDataFile baseData = new FreeColDataFile(new File(dataFolder, "base"));
            try {
                ResourceManager.setBaseMapping(baseData.getResourceMapping());
            }
            finally {
                baseData.close();
            }
        }
        catch (IOException e) {
            System.err.println("Could not find base data directory.");
            return false;
        }
        try {
            tcData = new FreeColTcFile(new File(dataFolder, tc));
            try {
                ResourceManager.setTcMapping(tcData.getResourceMapping());
            }
            finally {
                tcData.close();
            }
        }
        catch (IOException e) {
            System.err.println("Could not load: " + tc);
            return false;
        }
        try {
            Specification.createSpecification(tcData.getSpecificationInputStream());
        }
        catch (IOException e) {
            System.err.println("Could not load specification.xml for: " + tc);
            return false;
        }
        ResourceManager.update();
        return true;
    }

    private static boolean checkJavaVersion() {
        String version = System.getProperty("java.version");
        boolean success = version.compareTo(MIN_JDK_VERSION) >= 0;
        return success;
    }

    private static void handleArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--freecol-data")) {
                if (++i < args.length) {
                    dataFolder = args[i];
                    if (dataFolder.endsWith(FILE_SEP)) continue;
                    dataFolder = dataFolder + FILE_SEP;
                    continue;
                }
                FreeCol.printUsage();
                System.exit(1);
                continue;
            }
            if (args[i].equals("--tc")) {
                if (++i < args.length) {
                    tc = args[i];
                    continue;
                }
                FreeCol.printUsage();
                System.exit(1);
                continue;
            }
            if (args[i].equals("--home-directory")) {
                if (++i < args.length) {
                    mainUserDirectory = new File(args[i]);
                    continue;
                }
                FreeCol.printUsage();
                System.exit(1);
                continue;
            }
            if (args[i].equals("--log-console")) {
                consoleLogging = true;
                FreeCol.initLogging();
                continue;
            }
            if (args[i].equals("--log-level")) {
                if (++i < args.length) {
                    String logLevelString = args[i].toUpperCase();
                    try {
                        logLevel = Level.parse(logLevelString);
                        FreeCol.initLogging();
                    }
                    catch (IllegalArgumentException e) {
                        FreeCol.printUsage();
                        System.exit(1);
                    }
                    continue;
                }
                FreeCol.printUsage();
                System.exit(1);
                continue;
            }
            if (args[i].equals("--no-java-check")) {
                javaCheck = false;
                continue;
            }
            if (args[i].length() >= 10 && args[i].substring(0, 10).equals("--windowed")) {
                if (args[i].length() > 10 && args[i].charAt(10) != ' ') {
                    try {
                        int x = 0;
                        int j = 10;
                        if (args[i].charAt(10) == '=') {
                            ++j;
                        }
                        while (args[i].charAt(j) != 'x') {
                            x *= 10;
                            x += Character.digit(args[i].charAt(j), 10);
                            ++j;
                        }
                        int y = 0;
                        ++j;
                        while (j < args[i].length() && args[i].charAt(j) != ' ') {
                            y *= 10;
                            y += Character.digit(args[i].charAt(j), 10);
                            ++j;
                        }
                        windowSize = new Dimension(x, y);
                    }
                    catch (Exception e) {
                        FreeCol.printUsage();
                        System.exit(1);
                    }
                } else if (args[i].length() != 10) {
                    FreeCol.printUsage();
                    System.exit(1);
                }
                windowed = true;
                continue;
            }
            if (args[i].length() > 16 && args[i].substring(0, 16).equals("--default-locale")) {
                if (args[i].charAt(16) == '=') {
                    String languageID = args[i].substring(17);
                    int index = languageID.indexOf(46);
                    if (index > 0) {
                        languageID = languageID.substring(0, index);
                    }
                    Locale.setDefault(LanguageOption.getLocale(languageID));
                    continue;
                }
                FreeCol.printUsage();
                System.exit(1);
                continue;
            }
            if (args[i].equals("--no-sound")) {
                sound = false;
                continue;
            }
            if (args[i].equals("--no-memory-check")) {
                memoryCheck = false;
                continue;
            }
            if (args[i].equals("--usage") || args[i].equals("--help")) {
                FreeCol.printUsage();
                System.exit(0);
                continue;
            }
            if (args[i].equals("--version")) {
                System.out.println("FreeCol " + FreeCol.getVersion());
                System.exit(0);
                continue;
            }
            if (args[i].equals("--debug")) {
                inDebugMode = true;
                continue;
            }
            if (args[i].equals("--server")) {
                standAloneServer = true;
                if (++i >= args.length) {
                    FreeCol.printUsage();
                    System.out.println("You will need to specify a port number when using the \"--server\" option.");
                    System.exit(1);
                }
                try {
                    serverPort = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException nfe) {
                    FreeCol.printUsage();
                    System.out.println("The text after the \"--server\" option should be a valid port number.");
                    System.exit(1);
                }
                continue;
            }
            if (args[i].equals("--private")) {
                publicServer = false;
                continue;
            }
            if (args[i].equals("--load-savegame")) {
                if (++i < args.length) {
                    FreeCol.setSavegame(args[i]);
                    continue;
                }
                FreeCol.printUsage();
                System.exit(1);
                continue;
            }
            if (args[i].equals("--server-help")) {
                FreeCol.printServerUsage();
                System.exit(0);
                continue;
            }
            if (args[i].equals("--server-name")) {
                if (!standAloneServer) {
                    FreeCol.printServerUsage();
                    System.exit(1);
                }
                if (++i >= args.length) {
                    FreeCol.printUsage();
                    System.out.println("You will need to specify a name when using the \"--server-name\" option.");
                    System.exit(1);
                }
                serverName = args[i];
                continue;
            }
            if (args[i].startsWith("--splash")) continue;
            if (args[i].equals("--check-savegame")) {
                if (++i < args.length) {
                    FreeCol.setSavegame(args[i]);
                } else {
                    FreeCol.printUsage();
                    System.exit(1);
                }
                checkIntegrity = true;
                standAloneServer = true;
                serverPort = 3541;
                continue;
            }
            FreeCol.printUsage();
            System.exit(1);
        }
    }

    public static String getVersion() {
        return FREECOL_VERSION;
    }

    public static String getRevision() {
        return FREECOL_REVISION;
    }

    public static boolean isInDebugMode() {
        return inDebugMode;
    }

    public static void setInDebugMode(boolean debug) {
        inDebugMode = debug;
    }

    private static void printServerUsage() {
        System.out.println("Usage: java -Xmx512M -jar FreeCol.jar --server PORT [OPTIONS]");
        System.out.println("");
        System.out.println("Starts a stand-alone server on the specifed port");
        System.out.println("");
        System.out.println("Options:");
        System.out.println("--server-name NAME");
        System.out.println("  specifies a custom name for the server");
        System.out.println("--load-savegame SAVEGAME_FILE");
        System.out.println("  loads the given savegame.");
        System.out.println("--no-java-check");
        System.out.println("  skips the java version check");
        System.out.println();
    }

    private static void printUsage() {
        System.out.println("Usage: java -Xmx512M -jar FreeCol.jar [OPTIONS]");
        System.out.println("");
        System.out.println("Options:");
        System.out.println("--home-directory DIR");
        System.out.println("  sets the FreeCol home directory, defaults to user home.");
        System.out.println("--default-locale=LANGUAGE[_COUNTRY[_VARIANT]]");
        System.out.println("  sets the default locale.");
        System.out.println("--freecol-data DIR");
        System.out.println("  DIR should be the directory with FreeCol's data files, it");
        System.out.println("  has a subdirectory called 'images'");
        System.out.println("--load-savegame SAVEGAME_FILE");
        System.out.println("  loads the given savegame.");
        System.out.println("--log-level=LOGLEVEL");
        System.out.println("  sets the log-level to LOGLEVEL.");
        System.out.println("--no-java-check");
        System.out.println("  skips the java version check");
        System.out.println("--no-memory-check");
        System.out.println("  skips the memory check");
        System.out.println("--no-sound");
        System.out.println("  runs FreeCol without sound");
        System.out.println("--server PORT");
        System.out.println("  starts a stand-alone server on the specifed port");
        System.out.println("--private");
        System.out.println("  starts a private server (not published to the metaserver)");
        System.out.println("--server-help");
        System.out.println("  displays a help screen for the more advanced server options");
        System.out.println("--splash[=SPLASH_IMAGE_FILE]");
        System.out.println("  displays a splash screen while loading the game");
        System.out.println("--tc NAME");
        System.out.println("  Loads the total conversion with the given NAME");
        System.out.println("--usage");
        System.out.println("  displays this help screen");
        System.out.println("--version");
        System.out.println("  displays the version number");
        System.out.println("--windowed[[=]WIDTHxHEIGHT]");
        System.out.println("  runs FreeCol in windowed mode instead of full screen mode");
        System.out.println();
    }

    static {
        FILE_SEP = System.getProperty("file.separator");
        windowed = false;
        sound = true;
        javaCheck = true;
        memoryCheck = true;
        consoleLogging = false;
        windowSize = new Dimension(-1, -1);
        dataFolder = "data" + FILE_SEP;
        standAloneServer = false;
        publicServer = true;
        inDebugMode = false;
        serverName = null;
        tc = DEFAULT_TC;
        savegameFile = null;
        clientOptionsFile = null;
        logLevel = Level.INFO;
        checkIntegrity = false;
    }
}

