/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client;

import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Queue;
import java.util.Random;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.Worker;
import net.sf.freecol.client.control.ClientModelController;
import net.sf.freecol.client.control.ConnectController;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.control.InGameInputHandler;
import net.sf.freecol.client.control.MapEditorController;
import net.sf.freecol.client.control.PreGameController;
import net.sf.freecol.client.control.PreGameInputHandler;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.FullScreenFrame;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.WindowedFrame;
import net.sf.freecol.client.gui.action.ActionManager;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.sound.MusicLibrary;
import net.sf.freecol.client.gui.sound.SfxLibrary;
import net.sf.freecol.client.gui.sound.SoundLibrary;
import net.sf.freecol.client.gui.sound.SoundPlayer;
import net.sf.freecol.client.networking.Client;
import net.sf.freecol.common.PseudoRandom;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.option.AudioMixerOption;
import net.sf.freecol.common.option.LanguageOption;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.PercentageOption;
import net.sf.freecol.server.FreeColServer;
import org.w3c.dom.Element;

public final class FreeColClient {
    private static final Logger logger = Logger.getLogger(FreeColClient.class.getName());
    private ConnectController connectController;
    private PreGameController preGameController;
    private PreGameInputHandler preGameInputHandler;
    private InGameController inGameController;
    private InGameInputHandler inGameInputHandler;
    private ClientModelController modelController;
    private MapEditorController mapEditorController;
    private GraphicsDevice gd;
    private JFrame frame;
    private Canvas canvas;
    private GUI gui;
    private ImageLibrary imageLibrary;
    private MusicLibrary musicLibrary;
    private SfxLibrary sfxLibrary;
    private SoundPlayer musicPlayer;
    private SoundPlayer sfxPlayer;
    private Client client;
    private Game game;
    private final PseudoRandom _random = new ClientPseudoRandom();
    private Player player;
    private FreeColServer freeColServer = null;
    private boolean windowed;
    private boolean mapEditor;
    private boolean singleplayer;
    private final ActionManager actionManager;
    private ClientOptions clientOptions;
    public final Worker worker;
    private boolean loggedIn = false;
    private Rectangle windowBounds;
    private boolean headless = "true".equals(System.getProperty("java.awt.headless", "false"));

    public FreeColClient(boolean windowed, final Dimension innerWindowSize, ImageLibrary imageLibrary, MusicLibrary musicLibrary, SfxLibrary sfxLibrary) {
        this.windowed = windowed;
        this.imageLibrary = imageLibrary;
        this.musicLibrary = musicLibrary;
        this.sfxLibrary = sfxLibrary;
        this.mapEditor = false;
        this.clientOptions = new ClientOptions();
        if (FreeCol.getClientOptionsFile() != null && FreeCol.getClientOptionsFile().exists()) {
            this.clientOptions.load(FreeCol.getClientOptionsFile());
        }
        this.actionManager = new ActionManager(this);
        if (!this.headless) {
            this.actionManager.initializeActions();
        }
        this.connectController = new ConnectController(this);
        this.preGameController = new PreGameController(this);
        this.preGameInputHandler = new PreGameInputHandler(this);
        this.inGameController = new InGameController(this);
        this.inGameInputHandler = new InGameInputHandler(this);
        this.modelController = new ClientModelController(this);
        this.mapEditorController = new MapEditorController(this);
        if (!this.headless) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FreeColClient.this.startGUI(innerWindowSize);
                }
            });
        }
        this.worker = new Worker();
        this.worker.start();
        if (FreeCol.getClientOptionsFile() != null && FreeCol.getClientOptionsFile().exists() && !this.headless) {
            Option o = this.clientOptions.getObject("model.option.languageOption");
            o.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    if (((LanguageOption.Language)e.getNewValue()).getKey().equals("automatic")) {
                        FreeColClient.this.canvas.showInformationMessage("autodetectLanguageSelected");
                    } else {
                        Locale l = ((LanguageOption.Language)e.getNewValue()).getLocale();
                        Messages.setMessageBundle(l);
                        FreeColClient.this.canvas.showInformationMessage("newLanguageSelected", "%language%", l.getDisplayName());
                    }
                }
            });
        }
    }

    private void startGUI(Dimension innerWindowSize) {
        AudioMixerOption amo = (AudioMixerOption)this.getClientOptions().getObject("audioMixer");
        if (this.musicLibrary != null) {
            this.musicPlayer = new SoundPlayer(amo, (PercentageOption)this.getClientOptions().getObject("musicVolume"), false, true);
            this.playMusic("intro");
        } else {
            this.musicPlayer = null;
        }
        this.sfxPlayer = this.sfxLibrary != null ? new SoundPlayer(amo, (PercentageOption)this.getClientOptions().getObject("sfxVolume"), true, false) : null;
        if (GraphicsEnvironment.isHeadless()) {
            logger.info("It seems that the GraphicsEnvironment is headless!");
        }
        this.gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        if (!this.windowed) {
            if (!this.gd.isFullScreenSupported()) {
                String fullscreenNotSupported = "\nIt seems that full screen mode is not fully supported for this\nGraphicsDevice. Please try the \"--windowed\" option if you\nexperience any graphical problems while running FreeCol.";
                logger.info(fullscreenNotSupported);
                System.out.println(fullscreenNotSupported);
            }
            Rectangle bounds = this.gd.getDefaultConfiguration().getBounds();
            innerWindowSize = new Dimension(bounds.width - bounds.x, bounds.height - bounds.y);
        }
        this.gui = new GUI(this, innerWindowSize, this.imageLibrary);
        this.canvas = new Canvas(this, innerWindowSize, this.gui);
        this.changeWindowedMode(this.windowed);
        UnitType galleonType = FreeCol.getSpecification().getUnitType("model.unit.galleon");
        this.frame.setIconImage(this.imageLibrary.getUnitImageIcon(galleonType).getImage());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FreeColClient.this.canvas.showMainPanel();
            }
        });
        this.gui.startCursorBlinking();
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public void setHeadless(boolean newHeadless) {
        this.headless = newHeadless;
    }

    public void changeWindowedMode(boolean windowed) {
        if (this.frame != null) {
            if (this.frame instanceof WindowedFrame) {
                this.windowBounds = this.frame.getBounds();
            }
            this.frame.setVisible(false);
            this.frame.dispose();
        }
        this.windowed = windowed;
        this.frame = windowed ? new WindowedFrame() : new FullScreenFrame(this.gd);
        if (this.frame instanceof WindowedFrame) {
            ((WindowedFrame)this.frame).setCanvas(this.canvas);
            this.frame.getContentPane().add(this.canvas);
            if (this.windowBounds != null) {
                this.frame.setBounds(this.windowBounds);
            } else {
                this.frame.pack();
            }
        } else if (this.frame instanceof FullScreenFrame) {
            ((FullScreenFrame)this.frame).setCanvas(this.canvas);
            this.frame.getContentPane().add(this.canvas);
            this.canvas.setSize(this.frame.getSize());
        }
        this.gui.forceReposition();
        this.canvas.updateSizes();
        this.frame.setVisible(true);
    }

    public boolean isWindowed() {
        return this.windowed;
    }

    public void saveClientOptions() {
        this.saveClientOptions(FreeCol.getClientOptionsFile());
    }

    public void setMapEditor(boolean mapEditor) {
        this.mapEditor = mapEditor;
    }

    public boolean isMapEditor() {
        return this.mapEditor;
    }

    public void saveClientOptions(File saveFile) {
        this.getClientOptions().save(saveFile);
    }

    public ImageLibrary getImageLibrary() {
        return this.imageLibrary;
    }

    public void loadClientOptions() {
        this.loadClientOptions(FreeCol.getClientOptionsFile());
    }

    public void loadClientOptions(File loadFile) {
        this.getClientOptions().load(loadFile);
    }

    public ActionManager getActionManager() {
        return this.actionManager;
    }

    public ClientOptions getClientOptions() {
        return this.clientOptions;
    }

    public MapEditorController getMapEditorController() {
        return this.mapEditorController;
    }

    public Player getMyPlayer() {
        return this.player;
    }

    public void setMyPlayer(Player player) {
        this.player = player;
    }

    public void setFreeColServer(FreeColServer freeColServer) {
        this.freeColServer = freeColServer;
    }

    public FreeColServer getFreeColServer() {
        return this.freeColServer;
    }

    public void setGame(Game game) {
        this.game = game;
    }

    public Game getGame() {
        return this.game;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public GUI getGUI() {
        return this.gui;
    }

    public void quit() {
        this.getConnectController().quitGame(true);
        if (!this.windowed) {
            this.gd.setFullScreenWindow(null);
        }
        System.exit(0);
    }

    public boolean retire() {
        Element retireElement = Message.createNewRootElement("retire");
        Element reply = this.client.ask(retireElement);
        return "true".equals(reply.getAttribute("highScore"));
    }

    public void continuePlaying() {
        Element continueElement = Message.createNewRootElement("continuePlaying");
        this.client.send(continueElement);
    }

    public boolean isAdmin() {
        if (this.getMyPlayer() == null) {
            return false;
        }
        return this.getMyPlayer().isAdmin();
    }

    public void setSingleplayer(boolean singleplayer) {
        this.singleplayer = singleplayer;
    }

    public boolean isSingleplayer() {
        return this.singleplayer;
    }

    public ConnectController getConnectController() {
        return this.connectController;
    }

    public PreGameController getPreGameController() {
        return this.preGameController;
    }

    public PreGameInputHandler getPreGameInputHandler() {
        return this.preGameInputHandler;
    }

    public InGameController getInGameController() {
        return this.inGameController;
    }

    public InGameInputHandler getInGameInputHandler() {
        return this.inGameInputHandler;
    }

    public ClientModelController getModelController() {
        return this.modelController;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public Client getClient() {
        return this.client;
    }

    public void playMusic(String music) {
        if (this.musicPlayer != null) {
            this.musicPlayer.play(this.musicLibrary.get(music));
        }
    }

    public void playMusicOnce(String music) {
        if (this.musicPlayer != null) {
            this.musicPlayer.playOnce(this.musicLibrary.get(music));
        }
    }

    public void playMusicOnce(String music, int delay) {
        if (this.musicPlayer != null) {
            this.musicPlayer.playOnce(this.musicLibrary.get(music), delay);
        }
    }

    public void playSound(String sound) {
        if (this.sfxPlayer != null) {
            this.sfxPlayer.play(this.sfxLibrary.get(sound));
        }
    }

    public void playSound(SoundLibrary.SoundEffect sound) {
        if (this.sfxPlayer != null) {
            this.sfxPlayer.play(this.sfxLibrary.get(sound));
        }
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public void setLoggedIn(boolean loggedIn) {
        this.loggedIn = loggedIn;
    }

    public PseudoRandom getPseudoRandom() {
        return this._random;
    }

    private class ClientPseudoRandom
    implements PseudoRandom {
        private final Random offlineRandom;
        private final Queue<Integer> values = new LinkedList<Integer>();
        private static final int VALUES_PER_CALL = 100;

        ClientPseudoRandom() {
            this.offlineRandom = new Random();
        }

        public int nextInt(int n) {
            if (n <= 0) {
                throw new IllegalArgumentException("n must be positive!");
            }
            return Math.abs(this.nextInt() % n);
        }

        private int nextInt() {
            Integer i = this.pop();
            while (i == null) {
                this.getNewNumbers();
                i = this.pop();
            }
            return i;
        }

        private void getNewNumbers() {
            int valuesAdded = 0;
            if (FreeColClient.this.isLoggedIn()) {
                Element query = Message.createNewRootElement("getRandomNumbers");
                query.setAttribute("n", String.valueOf(100));
                Element answer = FreeColClient.this.getClient().ask(query);
                if (answer != null && "getRandomNumbersConfirmed".equals(answer.getTagName())) {
                    for (String s : answer.getAttribute("result").split(",")) {
                        this.push(new Integer(s));
                        ++valuesAdded;
                    }
                } else {
                    logger.warning("Expected getRandomNumbersConfirmed, got " + (answer != null ? answer.getTagName() : "null"));
                }
            }
            if (valuesAdded < 1) {
                logger.fine("Generating random number on client side");
                this.push(this.offlineRandom.nextInt());
            }
        }

        private synchronized void push(Integer i) {
            this.values.offer(i);
        }

        private synchronized Integer pop() {
            return this.values.poll();
        }
    }
}

